/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.RaftGroupIdCodec;
import com.hazelcast.cp.internal.RaftGroupId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class FencedLockUnlockCodec {
    public static final int REQUEST_MESSAGE_TYPE = 459520;
    public static final int RESPONSE_MESSAGE_TYPE = 459521;
    private static final int REQUEST_SESSION_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_THREAD_ID_FIELD_OFFSET = 24;
    private static final int REQUEST_INVOCATION_UID_FIELD_OFFSET = 32;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 49;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 17;

    private FencedLockUnlockCodec() {
    }

    public static ClientMessage encodeRequest(RaftGroupId groupId, String name, long sessionId, long threadId, UUID invocationUid) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("FencedLock.Unlock");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[49], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 459520);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, sessionId);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, threadId);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 32, invocationUid);
        clientMessage.add(initialFrame);
        RaftGroupIdCodec.encode(clientMessage, groupId);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.sessionId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.threadId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        request.invocationUid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 32);
        request.groupId = RaftGroupIdCodec.decode(iterator);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(boolean response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 459521);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public boolean response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public RaftGroupId groupId;
        public String name;
        public long sessionId;
        public long threadId;
        public UUID invocationUid;
    }
}

