/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;

public final class MapFetchWithQueryCodec {
    public static final int REQUEST_MESSAGE_TYPE = 83456;
    public static final int RESPONSE_MESSAGE_TYPE = 83457;
    private static final int REQUEST_TABLE_INDEX_FIELD_OFFSET = 16;
    private static final int REQUEST_BATCH_FIELD_OFFSET = 20;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 24;
    private static final int RESPONSE_NEXT_TABLE_INDEX_TO_READ_FROM_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 20;

    private MapFetchWithQueryCodec() {
    }

    public static ClientMessage encodeRequest(String name, int tableIndex, int batch, Data projection, Data predicate) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Map.FetchWithQuery");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 83456);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, tableIndex);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, batch);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, projection);
        DataCodec.encode(clientMessage, predicate);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.tableIndex = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.batch = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.name = StringCodec.decode(iterator);
        request.projection = DataCodec.decode(iterator);
        request.predicate = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(Collection<Data> results, int nextTableIndexToReadFrom) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 83457);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, nextTableIndexToReadFrom);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encodeContainsNullable(clientMessage, results, DataCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.nextTableIndexToReadFrom = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        response.results = ListMultiFrameCodec.decodeContainsNullable(iterator, DataCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public List<Data> results;
        public int nextTableIndexToReadFrom;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int tableIndex;
        public int batch;
        public Data projection;
        public Data predicate;
    }
}

