/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListLongByteArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class MetricsReadMetricsCodec {
    public static final int REQUEST_MESSAGE_TYPE = 2556160;
    public static final int RESPONSE_MESSAGE_TYPE = 2556161;
    private static final int REQUEST_UUID_FIELD_OFFSET = 16;
    private static final int REQUEST_FROM_SEQUENCE_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 41;
    private static final int RESPONSE_NEXT_SEQUENCE_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 24;

    private MetricsReadMetricsCodec() {
    }

    public static ClientMessage encodeRequest(UUID uuid, long fromSequence) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Metrics.ReadMetrics");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[41], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2556160);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, uuid);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 33, fromSequence);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.fromSequence = FixedSizeTypesCodec.decodeLong(initialFrame.content, 33);
        return request;
    }

    public static ClientMessage encodeResponse(Collection<Map.Entry<Long, byte[]>> elements, long nextSequence) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2556161);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, nextSequence);
        clientMessage.add(initialFrame);
        EntryListLongByteArrayCodec.encode(clientMessage, elements);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.nextSequence = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        response.elements = EntryListLongByteArrayCodec.decode(iterator);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public List<Map.Entry<Long, byte[]>> elements;
        public long nextSequence;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public UUID uuid;
        public long fromSequence;
    }
}

