/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListUUIDLongCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.cluster.Address;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class PNCounterGetCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x200100;
    public static final int RESPONSE_MESSAGE_TYPE = 0x200101;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_VALUE_FIELD_OFFSET = 16;
    private static final int RESPONSE_REPLICA_COUNT_FIELD_OFFSET = 24;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 28;

    private PNCounterGetCodec() {
    }

    public static ClientMessage encodeRequest(String name, Collection<Map.Entry<UUID, Long>> replicaTimestamps, Address targetReplica) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("PNCounter.Get");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x200100);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        EntryListUUIDLongCodec.encode(clientMessage, replicaTimestamps);
        AddressCodec.encode(clientMessage, targetReplica);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        request.name = StringCodec.decode(iterator);
        request.replicaTimestamps = EntryListUUIDLongCodec.decode(iterator);
        request.targetReplica = AddressCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(long value, Collection<Map.Entry<UUID, Long>> replicaTimestamps, int replicaCount) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[28], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x200101);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, value);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, replicaCount);
        clientMessage.add(initialFrame);
        EntryListUUIDLongCodec.encode(clientMessage, replicaTimestamps);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.value = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        response.replicaCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        response.replicaTimestamps = EntryListUUIDLongCodec.decode(iterator);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public long value;
        public List<Map.Entry<UUID, Long>> replicaTimestamps;
        public int replicaCount;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public List<Map.Entry<UUID, Long>> replicaTimestamps;
        public Address targetReplica;
    }
}

