/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListScheduledTaskHandlerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MemberCodec;
import com.hazelcast.cluster.Member;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ScheduledExecutorGetAllScheduledFuturesCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1901568;
    public static final int RESPONSE_MESSAGE_TYPE = 1901569;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private ScheduledExecutorGetAllScheduledFuturesCodec() {
    }

    public static ClientMessage encodeRequest(String schedulerName) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("ScheduledExecutor.GetAllScheduledFutures");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1901568);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, schedulerName);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        request.schedulerName = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(Collection<Map.Entry<Member, List<ScheduledTaskHandler>>> handlers) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1901569);
        clientMessage.add(initialFrame);
        EntryListCodec.encode(clientMessage, handlers, MemberCodec::encode, ListScheduledTaskHandlerCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        response.handlers = EntryListCodec.decode(iterator, MemberCodec::decode, ListScheduledTaskHandlerCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public List<Map.Entry<Member, List<ScheduledTaskHandler>>> handlers;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String schedulerName;
    }
}

