/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.cluster.Address;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class ScheduledExecutorGetStatsFromAddressCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1902080;
    public static final int RESPONSE_MESSAGE_TYPE = 1902081;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_LAST_IDLE_TIME_NANOS_FIELD_OFFSET = 16;
    private static final int RESPONSE_TOTAL_IDLE_TIME_NANOS_FIELD_OFFSET = 24;
    private static final int RESPONSE_TOTAL_RUNS_FIELD_OFFSET = 32;
    private static final int RESPONSE_TOTAL_RUN_TIME_NANOS_FIELD_OFFSET = 40;
    private static final int RESPONSE_LAST_RUN_DURATION_NANOS_FIELD_OFFSET = 48;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 56;

    private ScheduledExecutorGetStatsFromAddressCodec() {
    }

    public static ClientMessage encodeRequest(String schedulerName, String taskName, Address address) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("ScheduledExecutor.GetStatsFromAddress");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1902080);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, schedulerName);
        StringCodec.encode(clientMessage, taskName);
        AddressCodec.encode(clientMessage, address);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        request.schedulerName = StringCodec.decode(iterator);
        request.taskName = StringCodec.decode(iterator);
        request.address = AddressCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(long lastIdleTimeNanos, long totalIdleTimeNanos, long totalRuns, long totalRunTimeNanos, long lastRunDurationNanos) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[56], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1902081);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, lastIdleTimeNanos);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, totalIdleTimeNanos);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 32, totalRuns);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 40, totalRunTimeNanos);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 48, lastRunDurationNanos);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.lastIdleTimeNanos = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        response.totalIdleTimeNanos = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        response.totalRuns = FixedSizeTypesCodec.decodeLong(initialFrame.content, 32);
        response.totalRunTimeNanos = FixedSizeTypesCodec.decodeLong(initialFrame.content, 40);
        response.lastRunDurationNanos = FixedSizeTypesCodec.decodeLong(initialFrame.content, 48);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public long lastIdleTimeNanos;
        public long totalIdleTimeNanos;
        public long totalRuns;
        public long totalRunTimeNanos;
        public long lastRunDurationNanos;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String schedulerName;
        public String taskName;
        public Address address;
    }
}

