/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class TransactionCreateCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1507840;
    public static final int RESPONSE_MESSAGE_TYPE = 1507841;
    private static final int REQUEST_TIMEOUT_FIELD_OFFSET = 16;
    private static final int REQUEST_DURABILITY_FIELD_OFFSET = 24;
    private static final int REQUEST_TRANSACTION_TYPE_FIELD_OFFSET = 28;
    private static final int REQUEST_THREAD_ID_FIELD_OFFSET = 32;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 40;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 33;

    private TransactionCreateCodec() {
    }

    public static ClientMessage encodeRequest(long timeout, int durability, int transactionType, long threadId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(true);
        clientMessage.setOperationName("Transaction.Create");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[40], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1507840);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, timeout);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, durability);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, transactionType);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 32, threadId);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.timeout = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.durability = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.transactionType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
        request.threadId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 32);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1507841);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public UUID response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public long timeout;
        public int durability;
        public int transactionType;
        public long threadId;
    }
}

