/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.custom.XidCodec;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.transaction.xa.Xid;

public final class XATransactionCreateCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1443072;
    public static final int RESPONSE_MESSAGE_TYPE = 1443073;
    private static final int REQUEST_TIMEOUT_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 24;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 33;

    private XATransactionCreateCodec() {
    }

    public static ClientMessage encodeRequest(Xid xid, long timeout) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(true);
        clientMessage.setOperationName("XATransaction.Create");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1443072);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, timeout);
        clientMessage.add(initialFrame);
        XidCodec.encode(clientMessage, xid);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.timeout = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.xid = XidCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1443073);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public UUID response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public SerializableXID xid;
        public long timeout;
    }
}

