/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class XATransactionRollbackCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1443584;
    public static final int RESPONSE_MESSAGE_TYPE = 1443585;
    private static final int REQUEST_TRANSACTION_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 33;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private XATransactionRollbackCodec() {
    }

    public static ClientMessage encodeRequest(UUID transactionId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("XATransaction.Rollback");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1443584);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, transactionId);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.transactionId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1443585);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public UUID transactionId;
    }
}

