/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.cache.CacheEventType;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.internal.nio.Bits;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class FixedSizeTypesCodec {
    public static final int BYTE_SIZE_IN_BYTES = 1;
    public static final int LONG_SIZE_IN_BYTES = 8;
    public static final int INT_SIZE_IN_BYTES = 4;
    public static final int ENUM_SIZE_IN_BYTES = 4;
    public static final int BOOLEAN_SIZE_IN_BYTES = 1;
    public static final int UUID_SIZE_IN_BYTES = 17;

    private FixedSizeTypesCodec() {
    }

    public static void encodeInt(byte[] buffer, int pos, int value) {
        Bits.writeIntL(buffer, pos, value);
    }

    public static int decodeInt(byte[] buffer, int pos) {
        return Bits.readIntL(buffer, pos);
    }

    public static void encodeEnum(byte[] buffer, int pos, CacheEventType cacheEventType) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, cacheEventType.getType());
    }

    public static void encodeEnum(byte[] buffer, int pos, IndexType indexType) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, indexType.getId());
    }

    public static void encodeEnum(byte[] buffer, int pos, CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, expiryPolicyType.getId());
    }

    public static void encodeEnum(byte[] buffer, int pos, TimeUnit timeUnit) {
        int timeUnitId = TimeUnit.NANOSECONDS.equals((Object)timeUnit) ? 0 : (TimeUnit.MICROSECONDS.equals((Object)timeUnit) ? 1 : (TimeUnit.MILLISECONDS.equals((Object)timeUnit) ? 2 : (TimeUnit.SECONDS.equals((Object)timeUnit) ? 3 : (TimeUnit.MINUTES.equals((Object)timeUnit) ? 4 : (TimeUnit.HOURS.equals((Object)timeUnit) ? 5 : (TimeUnit.DAYS.equals((Object)timeUnit) ? 6 : -1))))));
        FixedSizeTypesCodec.encodeInt(buffer, pos, timeUnitId);
    }

    public static int decodeEnum(byte[] buffer, int pos) {
        return FixedSizeTypesCodec.decodeInt(buffer, pos);
    }

    public static void encodeInteger(byte[] buffer, int pos, Integer value) {
        Bits.writeIntL(buffer, pos, (int)value);
    }

    public static Integer decodeInteger(byte[] buffer, int pos) {
        return Bits.readIntL(buffer, pos);
    }

    public static void encodeLong(byte[] buffer, int pos, long value) {
        Bits.writeLongL(buffer, pos, value);
    }

    public static long decodeLong(byte[] buffer, int pos) {
        return Bits.readLongL(buffer, pos);
    }

    public static void encodeBoolean(byte[] buffer, int pos, boolean value) {
        buffer[pos] = (byte)(value ? 1 : 0);
    }

    public static boolean decodeBoolean(byte[] buffer, int pos) {
        return buffer[pos] == 1;
    }

    public static void encodeByte(byte[] buffer, int pos, byte value) {
        buffer[pos] = value;
    }

    public static byte decodeByte(byte[] buffer, int pos) {
        return buffer[pos];
    }

    public static void encodeUUID(byte[] buffer, int pos, UUID value) {
        boolean isNull = value == null;
        FixedSizeTypesCodec.encodeBoolean(buffer, pos, isNull);
        if (isNull) {
            return;
        }
        long mostSigBits = value.getMostSignificantBits();
        long leastSigBits = value.getLeastSignificantBits();
        FixedSizeTypesCodec.encodeLong(buffer, pos + 1, mostSigBits);
        FixedSizeTypesCodec.encodeLong(buffer, pos + 1 + 8, leastSigBits);
    }

    public static UUID decodeUUID(byte[] buffer, int pos) {
        boolean isNull = FixedSizeTypesCodec.decodeBoolean(buffer, pos);
        if (isNull) {
            return null;
        }
        long mostSigBits = FixedSizeTypesCodec.decodeLong(buffer, pos + 1);
        long leastSigBits = FixedSizeTypesCodec.decodeLong(buffer, pos + 1 + 8);
        return new UUID(mostSigBits, leastSigBits);
    }
}

