/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.EvictionConfigHolder;
import com.hazelcast.nio.serialization.Data;

public final class EvictionConfigHolderCodec {
    private static final int SIZE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private EvictionConfigHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, EvictionConfigHolder evictionConfigHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, evictionConfigHolder.getSize());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, evictionConfigHolder.getMaxSizePolicy());
        StringCodec.encode(clientMessage, evictionConfigHolder.getEvictionPolicy());
        CodecUtil.encodeNullable(clientMessage, evictionConfigHolder.getComparatorClassName(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, evictionConfigHolder.getComparator(), DataCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static EvictionConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int size = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String maxSizePolicy = StringCodec.decode(iterator);
        String evictionPolicy = StringCodec.decode(iterator);
        String comparatorClassName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        Data comparator = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new EvictionConfigHolder(size, maxSizePolicy, evictionPolicy, comparatorClassName, comparator);
    }
}

