/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.custom.DurationConfigCodec;
import com.hazelcast.config.CacheSimpleConfig;

public final class TimedExpiryPolicyFactoryConfigCodec {
    private static final int EXPIRY_POLICY_TYPE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private TimedExpiryPolicyFactoryConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeEnum(initialFrame.content, 0, timedExpiryPolicyFactoryConfig.getExpiryPolicyType());
        clientMessage.add(initialFrame);
        DurationConfigCodec.encode(clientMessage, timedExpiryPolicyFactoryConfig.getDurationConfig());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int expiryPolicyType = FixedSizeTypesCodec.decodeEnum(initialFrame.content, 0);
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = DurationConfigCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createTimedExpiryPolicyFactoryConfig(expiryPolicyType, durationConfig);
    }
}

