/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public abstract class AbstractAddressMessageTask<P>
extends AbstractMessageTask<P>
implements BiConsumer<Object, Throwable>,
Executor {
    protected AbstractAddressMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    protected void beforeProcess() {
    }

    protected void beforeResponse() {
    }

    protected void afterResponse() {
    }

    @Override
    public final void processMessage() {
        this.beforeProcess();
        Operation op = this.prepareOperation();
        op.setCallerUuid(this.endpoint.getUuid());
        InvocationFuture f = this.nodeEngine.getOperationService().createInvocationBuilder(this.getServiceName(), op, this.getAddress()).setResultDeserialized(false).invoke();
        f.whenCompleteAsync((BiConsumer)this, (Executor)this);
    }

    protected abstract Address getAddress();

    protected abstract Operation prepareOperation();

    @Override
    public void execute(Runnable command) {
        if (Thread.currentThread().getClass() == PartitionOperationThread.class) {
            command.run();
        } else {
            ExecutionService executionService = this.nodeEngine.getExecutionService();
            ManagedExecutorService executor = executionService.getExecutor("hz:async");
            executor.execute(command);
        }
    }

    @Override
    public void accept(Object response, Throwable throwable) {
        if (throwable == null) {
            this.beforeResponse();
            this.sendResponse(response);
            this.afterResponse();
        } else {
            this.beforeResponse();
            this.handleProcessingFailure(throwable);
            this.afterResponse();
        }
    }
}

