/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.cluster.Member;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public abstract class AbstractMultiTargetMessageTask<P>
extends AbstractMessageTask<P> {
    protected AbstractMultiTargetMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void processMessage() throws Throwable {
        Supplier<Operation> operationSupplier = this.createOperationSupplier();
        Collection<Member> targets = this.getTargets();
        this.returnResponseIfNoTargetLeft(targets, Collections.EMPTY_MAP);
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        MultiTargetCallback callback = new MultiTargetCallback(targets);
        for (Member target : targets) {
            Operation op = operationSupplier.get();
            InvocationBuilder builder = operationService.createInvocationBuilder(this.getServiceName(), op, target.getAddress()).setResultDeserialized(false);
            builder.invoke().whenCompleteAsync((BiConsumer)new SingleTargetCallback(target, callback));
        }
    }

    private void returnResponseIfNoTargetLeft(Collection<Member> targets, Map<Member, Object> results) throws Throwable {
        if (targets.isEmpty()) {
            this.sendResponse(this.reduce(results));
        }
    }

    protected abstract Supplier<Operation> createOperationSupplier();

    protected abstract Object reduce(Map<Member, Object> var1) throws Throwable;

    public abstract Collection<Member> getTargets();

    private final class SingleTargetCallback
    implements BiConsumer<Object, Throwable> {
        final Member target;
        final MultiTargetCallback parent;

        private SingleTargetCallback(Member target, MultiTargetCallback parent) {
            this.target = target;
            this.parent = parent;
        }

        @Override
        public void accept(Object object, Throwable throwable) {
            this.parent.notify(this.target, throwable == null ? object : throwable);
        }
    }

    private final class MultiTargetCallback {
        final Collection<Member> targets;
        final Map<Member, Object> results;

        private MultiTargetCallback(Collection<Member> targets) {
            this.targets = new HashSet<Member>(targets);
            this.results = MapUtil.createHashMap(targets.size());
        }

        public synchronized void notify(Member target, Object result) {
            if (!this.targets.remove(target)) {
                if (this.results.containsKey(target)) {
                    throw new IllegalArgumentException("Duplicate response from -> " + target);
                }
                throw new IllegalArgumentException("Unknown target! -> " + target);
            }
            this.results.put(target, result);
            try {
                AbstractMultiTargetMessageTask.this.returnResponseIfNoTargetLeft(this.targets, this.results);
            }
            catch (Throwable throwable) {
                AbstractMultiTargetMessageTask.this.handleProcessingFailure(throwable);
            }
        }
    }
}

