/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public abstract class AbstractPartitionMessageTask<P>
extends AbstractMessageTask<P>
implements Executor,
PartitionSpecificRunnable,
BiConsumer<Object, Throwable> {
    protected AbstractPartitionMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    protected void beforeProcess() {
    }

    protected void beforeResponse() {
    }

    protected void afterResponse() {
    }

    @Override
    public int getPartitionId() {
        return this.clientMessage.getPartitionId();
    }

    @Override
    public final void processMessage() {
        this.beforeProcess();
        Operation op = this.prepareOperation();
        if (ClientMessage.isFlagSet(this.clientMessage.getHeaderFlags(), 256)) {
            op.setClientCallId(this.clientMessage.getCorrelationId());
        }
        op.setCallerUuid(this.endpoint.getUuid());
        InvocationFuture f = this.nodeEngine.getOperationService().createInvocationBuilder(this.getServiceName(), op, this.getPartitionId()).setResultDeserialized(false).invoke();
        ((CompletableFuture)f).whenCompleteAsync((BiConsumer)this, (Executor)this);
    }

    protected abstract Operation prepareOperation();

    @Override
    public void execute(Runnable command) {
        if (Thread.currentThread().getClass() == PartitionOperationThread.class) {
            command.run();
        } else {
            ExecutionService executionService = this.nodeEngine.getExecutionService();
            ManagedExecutorService executor = executionService.getExecutor("hz:async");
            executor.execute(command);
        }
    }

    @Override
    public void accept(Object response, Throwable throwable) {
        if (throwable == null) {
            this.beforeResponse();
            this.sendResponse(response);
            this.afterResponse();
        } else {
            this.beforeResponse();
            this.handleProcessingFailure(throwable);
            this.afterResponse();
        }
    }
}

