/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.client.impl.protocol.task.BlockingMessageTask;
import com.hazelcast.client.impl.protocol.task.UrgentMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.ConnectionType;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.security.Permission;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public abstract class AuthenticationBaseMessageTask<P>
extends AbstractMessageTask<P>
implements BlockingMessageTask,
UrgentMessageTask {
    protected transient UUID clientUuid;
    protected transient String clientName;
    protected transient Set<String> labels;
    protected transient Credentials credentials;
    protected transient UUID clusterId;
    protected transient int partitionCount;
    transient byte clientSerializationVersion;
    transient String clientVersion;

    AuthenticationBaseMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public int getPartitionId() {
        return -1;
    }

    @Override
    protected boolean requiresAuthentication() {
        return false;
    }

    @Override
    public void processMessage() {
        switch (this.authenticate()) {
            case SERIALIZATION_VERSION_MISMATCH: {
                this.sendClientMessage(this.prepareSerializationVersionMismatchClientMessage());
                break;
            }
            case NOT_ALLOWED_IN_CLUSTER: {
                this.sendClientMessage(this.prepareNotAllowedInCluster());
                break;
            }
            case CREDENTIALS_FAILED: {
                this.sendClientMessage(this.prepareUnauthenticatedClientMessage());
                break;
            }
            case AUTHENTICATED: {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Processing authentication with clientUuid " + this.clientUuid);
                }
                this.sendClientMessage(this.prepareAuthenticatedClientMessage());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled authentication result");
            }
        }
    }

    private AuthenticationStatus authenticate() {
        if (this.endpoint.isAuthenticated()) {
            return AuthenticationStatus.AUTHENTICATED;
        }
        if (this.clientSerializationVersion != this.serializationService.getVersion()) {
            return AuthenticationStatus.SERIALIZATION_VERSION_MISMATCH;
        }
        if (this.credentials == null) {
            this.logger.severe("Could not retrieve Credentials object!");
            return AuthenticationStatus.CREDENTIALS_FAILED;
        }
        if (this.partitionCount != -1 && this.clientEngine.getPartitionService().getPartitionCount() != this.partitionCount) {
            this.logger.warning("Received auth from " + this.connection + " with clientUuid " + this.clientUuid + ",  authentication rejected because client has a different partition count. Partition count client expects :" + this.partitionCount + ", Member partition count:" + this.clientEngine.getPartitionService().getPartitionCount());
            return AuthenticationStatus.NOT_ALLOWED_IN_CLUSTER;
        }
        if (this.clusterId != null && !this.clientEngine.getClusterService().getClusterId().equals(this.clusterId)) {
            this.logger.warning("Received auth from " + this.connection + " with clientUuid " + this.clientUuid + ",  authentication rejected because client has a different cluster id. Cluster Id client expects :" + this.clusterId + ", Member partition count:" + this.clientEngine.getClusterService().getClusterId());
            return AuthenticationStatus.NOT_ALLOWED_IN_CLUSTER;
        }
        if (this.clientEngine.getSecurityContext() != null) {
            return this.authenticate(this.clientEngine.getSecurityContext());
        }
        if (this.credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)this.credentials;
            return this.verifyClusterName(usernamePasswordCredentials);
        }
        this.logger.severe("Hazelcast security is disabled.\nUsernamePasswordCredentials or cluster-name should be used for authentication!\nCurrent credentials type is: " + this.credentials.getClass().getName());
        return AuthenticationStatus.CREDENTIALS_FAILED;
    }

    private AuthenticationStatus authenticate(SecurityContext securityContext) {
        Connection connection = this.endpoint.getConnection();
        try {
            LoginContext lc = securityContext.createClientLoginContext(this.credentials, connection);
            lc.login();
            this.endpoint.setLoginContext(lc);
            return AuthenticationStatus.AUTHENTICATED;
        }
        catch (LoginException e) {
            this.logger.warning(e);
            return AuthenticationStatus.CREDENTIALS_FAILED;
        }
    }

    private AuthenticationStatus verifyClusterName(UsernamePasswordCredentials credentials) {
        String nodeClusterName = this.nodeEngine.getConfig().getClusterName();
        boolean usernameMatch = nodeClusterName.equals(credentials.getName());
        return usernameMatch ? AuthenticationStatus.AUTHENTICATED : AuthenticationStatus.CREDENTIALS_FAILED;
    }

    private ClientMessage prepareUnauthenticatedClientMessage() {
        Connection connection = this.endpoint.getConnection();
        this.logger.warning("Received auth from " + connection + " with clientUuid " + this.clientUuid + ", authentication failed");
        byte status = AuthenticationStatus.CREDENTIALS_FAILED.getId();
        return this.encodeAuth(status, null, null, this.serializationService.getVersion(), this.clientEngine.getPartitionService().getPartitionCount(), this.clientEngine.getClusterService().getClusterId());
    }

    private ClientMessage prepareNotAllowedInCluster() {
        byte status = AuthenticationStatus.NOT_ALLOWED_IN_CLUSTER.getId();
        return this.encodeAuth(status, null, null, this.serializationService.getVersion(), this.clientEngine.getPartitionService().getPartitionCount(), this.clientEngine.getClusterService().getClusterId());
    }

    private ClientMessage prepareSerializationVersionMismatchClientMessage() {
        return this.encodeAuth(AuthenticationStatus.SERIALIZATION_VERSION_MISMATCH.getId(), null, null, this.serializationService.getVersion(), this.clientEngine.getPartitionService().getPartitionCount(), this.clientEngine.getClusterService().getClusterId());
    }

    private ClientMessage prepareAuthenticatedClientMessage() {
        Connection connection = this.endpoint.getConnection();
        this.endpoint.authenticated(this.clientUuid, this.credentials, this.clientVersion, this.clientMessage.getCorrelationId(), this.clientName, this.labels);
        this.setConnectionType();
        if (!this.clientEngine.bind(this.endpoint)) {
            return this.prepareNotAllowedInCluster();
        }
        this.logger.info("Received auth from " + connection + ", successfully authenticated, clientUuid: " + this.clientUuid + ", client version: " + this.clientVersion);
        Address thisAddress = this.clientEngine.getThisAddress();
        byte status = AuthenticationStatus.AUTHENTICATED.getId();
        return this.encodeAuth(status, thisAddress, this.clientUuid, this.serializationService.getVersion(), this.clientEngine.getPartitionService().getPartitionCount(), this.clientEngine.getClusterService().getClusterId());
    }

    private void setConnectionType() {
        String type = this.getClientType();
        if ("JVM".equals(type)) {
            this.connection.setType(ConnectionType.JAVA_CLIENT);
        } else if ("CSP".equals(type)) {
            this.connection.setType(ConnectionType.CSHARP_CLIENT);
        } else if ("CPP".equals(type)) {
            this.connection.setType(ConnectionType.CPP_CLIENT);
        } else if ("PYH".equals(type)) {
            this.connection.setType(ConnectionType.PYTHON_CLIENT);
        } else if ("RBY".equals(type)) {
            this.connection.setType(ConnectionType.RUBY_CLIENT);
        } else if ("NJS".equals(type)) {
            this.connection.setType(ConnectionType.NODEJS_CLIENT);
        } else if ("GOO".equals(type)) {
            this.connection.setType(ConnectionType.GO_CLIENT);
        } else {
            this.logger.info("Unknown client type: " + type);
            this.connection.setType(ConnectionType.BINARY_CLIENT);
        }
    }

    protected abstract ClientMessage encodeAuth(byte var1, Address var2, UUID var3, byte var4, int var5, UUID var6);

    protected abstract String getClientType();

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

