/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetPartitionsCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.client.impl.protocol.task.UrgentMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.PartitionTableView;
import java.security.Permission;
import java.util.List;
import java.util.Map;

public class GetPartitionsMessageTask
extends AbstractCallableMessageTask<ClientGetPartitionsCodec.RequestParameters>
implements UrgentMessageTask {
    public GetPartitionsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public int getPartitionId() {
        return -1;
    }

    @Override
    protected Object call() {
        InternalPartitionService service = (InternalPartitionService)this.getService("hz:core:partitionService");
        service.firstArrangement();
        PartitionTableView partitionTableView = service.createPartitionTableView();
        int partitionStateVersion = partitionTableView.getVersion();
        Map<Address, List<Integer>> partitions = this.clientEngine.getPartitionListenerService().getPartitions(partitionTableView);
        return ClientGetPartitionsCodec.encodeResponse(partitions.entrySet(), partitionStateVersion);
    }

    @Override
    protected ClientGetPartitionsCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ClientGetPartitionsCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return (ClientMessage)response;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

