/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.dynamicconfig;

import com.hazelcast.client.impl.protocol.util.PropertiesUtil;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.ringbuffer.RingbufferStore;
import com.hazelcast.ringbuffer.RingbufferStoreFactory;
import java.util.Map;

public class RingbufferStoreConfigHolder {
    private final String className;
    private final String factoryClassName;
    private final Data implementation;
    private final Data factoryImplementation;
    private final Map<String, String> properties;
    private final boolean enabled;

    public RingbufferStoreConfigHolder(String className, String factoryClassName, Data implementation, Data factoryImplementation, Map<String, String> properties, boolean enabled) {
        this.className = className;
        this.factoryClassName = factoryClassName;
        this.implementation = implementation;
        this.factoryImplementation = factoryImplementation;
        this.properties = properties;
        this.enabled = enabled;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public Data getImplementation() {
        return this.implementation;
    }

    public Data getFactoryImplementation() {
        return this.factoryImplementation;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RingbufferStoreConfig asRingbufferStoreConfig(SerializationService serializationService) {
        RingbufferStoreConfig config = new RingbufferStoreConfig();
        config.setClassName(this.className);
        config.setEnabled(this.enabled);
        config.setFactoryClassName(this.factoryClassName);
        config.setProperties(PropertiesUtil.fromMap(this.properties));
        RingbufferStore storeImplementation = (RingbufferStore)serializationService.toObject(this.implementation);
        RingbufferStoreFactory storeFactoryImplementation = (RingbufferStoreFactory)serializationService.toObject(this.factoryImplementation);
        config.setStoreImplementation(storeImplementation);
        config.setFactoryImplementation(storeFactoryImplementation);
        return config;
    }

    public static RingbufferStoreConfigHolder of(RingbufferStoreConfig ringbufferStoreConfig, SerializationService serializationService) {
        if (ringbufferStoreConfig.getClassName() == null && ringbufferStoreConfig.getFactoryClassName() == null && ringbufferStoreConfig.getStoreImplementation() == null && ringbufferStoreConfig.getFactoryImplementation() == null && ringbufferStoreConfig.isEnabled()) {
            throw new IllegalArgumentException("One of className, factoryClassName, storeImplementation, factoryImplementation has to be not null");
        }
        return new RingbufferStoreConfigHolder(ringbufferStoreConfig.getClassName(), ringbufferStoreConfig.getFactoryClassName(), (Data)serializationService.toData(ringbufferStoreConfig.getStoreImplementation()), (Data)serializationService.toData(ringbufferStoreConfig.getFactoryImplementation()), PropertiesUtil.toMap(ringbufferStoreConfig.getProperties()), ringbufferStoreConfig.isEnabled());
    }
}

