/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.metrics;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MetricsReadMetricsCodec;
import com.hazelcast.client.impl.protocol.task.AbstractInvocationMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.metrics.managementcenter.ConcurrentArrayRingbuffer;
import com.hazelcast.internal.metrics.managementcenter.ReadMetricsOperation;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.List;
import java.util.Map;

public class ReadMetricsMessageTask
extends AbstractInvocationMessageTask<MetricsReadMetricsCodec.RequestParameters> {
    public ReadMetricsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        return this.nodeEngine.getOperationService().createInvocationBuilder(this.getServiceName(), op, this.nodeEngine.getThisAddress());
    }

    @Override
    protected Operation prepareOperation() {
        if (!((MetricsReadMetricsCodec.RequestParameters)this.parameters).uuid.equals(this.nodeEngine.getLocalMember().getUuid())) {
            throw new IllegalArgumentException("Requested metrics for member " + ((MetricsReadMetricsCodec.RequestParameters)this.parameters).uuid + ", but local member is " + this.nodeEngine.getLocalMember().getUuid());
        }
        return new ReadMetricsOperation(((MetricsReadMetricsCodec.RequestParameters)this.parameters).fromSequence);
    }

    @Override
    protected MetricsReadMetricsCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MetricsReadMetricsCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        ConcurrentArrayRingbuffer.RingbufferSlice ringbufferSlice = (ConcurrentArrayRingbuffer.RingbufferSlice)response;
        List<Map.Entry<Long, byte[]>> elements = ringbufferSlice.elements();
        long nextSequence = ringbufferSlice.nextSequence();
        return MetricsReadMetricsCodec.encodeResponse(elements, nextSequence);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:metricsService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "readMetrics";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }
}

