/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SetAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetClearCodec;
import com.hazelcast.client.impl.protocol.codec.SetCompareAndRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetCompareAndRetainAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetContainsAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetContainsCodec;
import com.hazelcast.client.impl.protocol.codec.SetGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.SetRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.SetRemoveListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetSizeCodec;
import com.hazelcast.client.impl.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.cluster.Member;
import com.hazelcast.collection.ISet;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ClientSetProxy<E>
extends PartitionSpecificClientProxy
implements ISet<E> {
    public ClientSetProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    public int size() {
        ClientMessage request = SetSizeCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SetSizeCodec.ResponseParameters resultParameters = SetSizeCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = SetIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SetIsEmptyCodec.ResponseParameters resultParameters = SetIsEmptyCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean contains(@Nonnull Object o) {
        Preconditions.checkNotNull(o, "Null item is not allowed");
        Data value = this.toData(o);
        ClientMessage request = SetContainsCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        SetContainsCodec.ResponseParameters resultParameters = SetContainsCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getAll().toArray();
    }

    @Override
    public <T> T[] toArray(@Nonnull T[] a) {
        Preconditions.checkNotNull(a, "Null array parameter is not allowed!");
        return this.getAll().toArray(a);
    }

    @Override
    public boolean add(@Nonnull E e) {
        Preconditions.checkNotNull(e, "Null item is not allowed");
        Data element = this.toData(e);
        ClientMessage request = SetAddCodec.encodeRequest(this.name, element);
        ClientMessage response = this.invokeOnPartition(request);
        SetAddCodec.ResponseParameters resultParameters = SetAddCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean remove(@Nonnull Object o) {
        Preconditions.checkNotNull(o, "Null item is not allowed");
        Data value = this.toData(o);
        ClientMessage request = SetRemoveCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        SetRemoveCodec.ResponseParameters resultParameters = SetRemoveCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = SetContainsAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        SetContainsAllCodec.ResponseParameters resultParameters = SetContainsAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = SetAddAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        SetAddAllCodec.ResponseParameters resultParameters = SetAddAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = SetCompareAndRemoveAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        SetCompareAndRemoveAllCodec.ResponseParameters resultParameters = SetCompareAndRemoveAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = SetCompareAndRetainAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        SetCompareAndRetainAllCodec.ResponseParameters resultParameters = SetCompareAndRetainAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void clear() {
        ClientMessage request = SetClearCodec.encodeRequest(this.name);
        this.invokeOnPartition(request);
    }

    @Override
    @Nonnull
    public UUID addItemListener(@Nonnull ItemListener<E> listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        ItemEventHandler eventHandler = new ItemEventHandler(listener);
        return this.registerListener(this.createItemListenerCodec(includeValue), eventHandler);
    }

    private ListenerMessageCodec createItemListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return SetAddListenerCodec.encodeRequest(ClientSetProxy.this.name, includeValue, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return SetAddListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return SetRemoveListenerCodec.encodeRequest(ClientSetProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return SetRemoveListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public boolean removeItemListener(@Nonnull UUID registrationId) {
        return this.deregisterListener(registrationId);
    }

    private Collection<E> getAll() {
        ClientMessage request = SetGetAllCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SetGetAllCodec.ResponseParameters resultParameters = SetGetAllCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.response;
        return new UnmodifiableLazyList(resultCollection, this.getSerializationService());
    }

    public String toString() {
        return "ISet{name='" + this.name + '\'' + '}';
    }

    private class ItemEventHandler
    extends SetAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ItemListener<E> listener;

        ItemEventHandler(ItemListener<E> listener) {
            this.listener = listener;
        }

        @Override
        public void handleItemEvent(Data dataItem, UUID uuid, int eventType) {
            Member member = ClientSetProxy.this.getContext().getClusterService().getMember(uuid);
            DataAwareItemEvent itemEvent = new DataAwareItemEvent(ClientSetProxy.this.name, ItemEventType.getByType(eventType), dataItem, member, ClientSetProxy.this.getSerializationService());
            if (eventType == ItemEventType.ADDED.getType()) {
                this.listener.itemAdded(itemEvent);
            } else {
                this.listener.itemRemoved(itemEvent);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

