/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TopicAddMessageListenerCodec;
import com.hazelcast.client.impl.protocol.codec.TopicPublishCodec;
import com.hazelcast.client.impl.protocol.codec.TopicRemoveMessageListenerCodec;
import com.hazelcast.client.impl.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.MessageListener;
import com.hazelcast.topic.impl.DataAwareMessage;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientTopicProxy<E>
extends PartitionSpecificClientProxy
implements ITopic<E> {
    public ClientTopicProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    @Override
    public void publish(@Nullable E message) {
        Data data = this.toData(message);
        ClientMessage request = TopicPublishCodec.encodeRequest(this.name, data);
        this.invokeOnPartition(request);
    }

    @Override
    @Nonnull
    public UUID addMessageListener(@Nonnull MessageListener<E> listener) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        TopicItemHandler handler = new TopicItemHandler(listener);
        return this.registerListener(new Codec(), handler);
    }

    @Override
    public boolean removeMessageListener(@Nonnull UUID registrationId) {
        return this.deregisterListener(registrationId);
    }

    @Override
    @Nonnull
    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public String toString() {
        return "ITopic{name='" + this.name + '\'' + '}';
    }

    private class Codec
    implements ListenerMessageCodec {
        private Codec() {
        }

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return TopicAddMessageListenerCodec.encodeRequest(ClientTopicProxy.this.name, localOnly);
        }

        @Override
        public UUID decodeAddResponse(ClientMessage clientMessage) {
            return TopicAddMessageListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
        }

        @Override
        public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
            return TopicRemoveMessageListenerCodec.encodeRequest(ClientTopicProxy.this.name, realRegistrationId);
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return TopicRemoveMessageListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    }

    private final class TopicItemHandler
    extends TopicAddMessageListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final MessageListener<E> listener;

        private TopicItemHandler(MessageListener<E> listener) {
            this.listener = listener;
        }

        @Override
        public void handleTopicEvent(Data item, long publishTime, UUID uuid) {
            Member member = ClientTopicProxy.this.getContext().getClusterService().getMember(uuid);
            DataAwareMessage message = new DataAwareMessage(ClientTopicProxy.this.name, item, publishTime, member, ClientTopicProxy.this.getSerializationService());
            this.listener.onMessage(message);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

