/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.concurrent.Future;

public class ClientInvokerWrapper
implements InvokerWrapper {
    private final QueryCacheContext context;
    private final HazelcastClientInstanceImpl client;

    public ClientInvokerWrapper(QueryCacheContext context, HazelcastClientInstanceImpl client) {
        this.context = context;
        this.client = client;
    }

    @Override
    public Future invokeOnPartitionOwner(Object request, int partitionId) {
        Preconditions.checkNotNull(request, "request cannot be null");
        Preconditions.checkNotNegative(partitionId, "partitionId");
        ClientMessage clientRequest = (ClientMessage)request;
        ClientInvocation clientInvocation = new ClientInvocation(this.client, clientRequest, null, partitionId);
        return clientInvocation.invoke();
    }

    @Override
    public Object invokeOnAllPartitions(Object request) {
        try {
            ClientMessage clientRequest = (ClientMessage)request;
            ClientInvocationFuture future = new ClientInvocation(this.client, clientRequest, null).invoke();
            Object result = future.get();
            return this.context.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Future invokeOnTarget(Object request, Address address) {
        Preconditions.checkNotNull(request, "request cannot be null");
        Preconditions.checkNotNull(address, "address cannot be null");
        ClientMessage clientRequest = (ClientMessage)request;
        ClientInvocation invocation = new ClientInvocation(this.client, clientRequest, null, address);
        return invocation.invoke();
    }

    @Override
    public Object invoke(Object request) {
        Preconditions.checkNotNull(request, "request cannot be null");
        ClientInvocation invocation = new ClientInvocation(this.client, (ClientMessage)request, null);
        ClientInvocationFuture future = invocation.invoke();
        try {
            Object result = future.get();
            return this.context.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public void executeOperation(Operation op) {
        throw new UnsupportedOperationException();
    }
}

