/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.connection.nio.ClusterConnectorService;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.ClientExecutionService;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.operationservice.impl.BaseInvocation;
import com.hazelcast.spi.impl.sequence.CallIdSequence;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ClientInvocation
extends BaseInvocation
implements Runnable {
    private static final int MAX_FAST_INVOCATION_COUNT = 5;
    private static final int UNASSIGNED_PARTITION = -1;
    private static final AtomicLongFieldUpdater<ClientInvocation> INVOKE_COUNT = AtomicLongFieldUpdater.newUpdater(ClientInvocation.class, "invokeCount");
    final LifecycleService lifecycleService;
    private final ClientInvocationFuture clientInvocationFuture;
    private final ILogger logger;
    private final ClientClusterService clientClusterService;
    private final AbstractClientInvocationService invocationService;
    private final ClientExecutionService executionService;
    private final ClusterConnectorService clusterConnectorService;
    private volatile ClientMessage clientMessage;
    private final CallIdSequence callIdSequence;
    private final Address address;
    private final int partitionId;
    private final Connection connection;
    private final long startTimeMillis;
    private final long retryPauseMillis;
    private final Object objectName;
    private volatile ClientConnection sendConnection;
    private EventHandler handler;
    private volatile long invokeCount;
    private volatile long invocationTimeoutMillis;

    protected ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Object objectName, int partitionId, Address address, Connection connection) {
        this.clusterConnectorService = client.getClusterConnectorService();
        this.clientClusterService = client.getClientClusterService();
        this.lifecycleService = client.getLifecycleService();
        this.invocationService = (AbstractClientInvocationService)client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.objectName = objectName;
        this.clientMessage = clientMessage;
        this.partitionId = partitionId;
        this.address = address;
        this.connection = connection;
        this.startTimeMillis = System.currentTimeMillis();
        this.retryPauseMillis = this.invocationService.getInvocationRetryPauseMillis();
        this.logger = this.invocationService.invocationLogger;
        this.callIdSequence = this.invocationService.getCallIdSequence();
        this.clientInvocationFuture = new ClientInvocationFuture(this, clientMessage, this.logger, this.callIdSequence);
        this.invocationTimeoutMillis = this.invocationService.getInvocationTimeoutMillis();
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Object objectName) {
        this(client, clientMessage, objectName, -1, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Object objectName, int partitionId) {
        this(client, clientMessage, objectName, partitionId, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Object objectName, Address address) {
        this(client, clientMessage, objectName, -1, address, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Object objectName, Connection connection) {
        this(client, clientMessage, objectName, -1, null, connection);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ClientMessage getClientMessage() {
        return this.clientMessage;
    }

    public ClientInvocationFuture invoke() {
        assert (this.clientMessage != null);
        this.clientMessage.setCorrelationId(this.callIdSequence.next());
        this.invokeOnSelection();
        return this.clientInvocationFuture;
    }

    public ClientInvocationFuture invokeUrgent() {
        assert (this.clientMessage != null);
        this.clientMessage.setCorrelationId(this.callIdSequence.forceNext());
        this.invokeOnSelection();
        return this.clientInvocationFuture;
    }

    private void invokeOnSelection() {
        INVOKE_COUNT.incrementAndGet(this);
        try {
            if (this.isBindToSingleConnection()) {
                this.invocationService.invokeOnConnection(this, (ClientConnection)this.connection);
            } else if (this.partitionId != -1) {
                this.invocationService.invokeOnPartitionOwner(this, this.partitionId);
            } else if (this.address != null) {
                this.invocationService.invokeOnTarget(this, this.address);
            } else {
                this.invocationService.invokeOnRandomTarget(this);
            }
        }
        catch (Exception e) {
            this.notifyException(e);
        }
    }

    @Override
    public void run() {
        this.retry();
    }

    private void retry() {
        long correlationId = this.callIdSequence.forceNext();
        this.clientMessage = this.clientMessage.copyWithNewCorrelationId(correlationId);
        this.callIdSequence.complete();
        try {
            this.invokeOnSelection();
        }
        catch (Throwable e) {
            this.completeExceptionally(e);
        }
    }

    public void setInvocationTimeoutMillis(long invocationTimeoutMillis) {
        this.invocationTimeoutMillis = invocationTimeoutMillis;
    }

    void notify(ClientMessage clientMessage) {
        assert (clientMessage != null) : "response can't be null";
        int expectedBackups = clientMessage.getNumberOfBackupAcks();
        this.notifyResponse(clientMessage, expectedBackups);
    }

    @Override
    protected boolean shouldCompleteWithoutBackups() {
        return true;
    }

    @Override
    protected void complete(Object response) {
        this.clientInvocationFuture.complete(response);
        this.invocationService.deRegisterInvocation(this.clientMessage.getCorrelationId());
    }

    @Override
    protected void completeExceptionally(Throwable t) {
        this.clientInvocationFuture.completeExceptionally(t);
        this.invocationService.deRegisterInvocation(this.clientMessage.getCorrelationId());
    }

    @Override
    protected boolean shouldFailOnIndeterminateOperationState() {
        return this.invocationService.shouldFailOnIndeterminateOperationState();
    }

    void notifyException(Throwable exception) {
        boolean retry;
        this.logException(exception);
        if (!this.lifecycleService.isRunning()) {
            this.completeExceptionally(new HazelcastClientNotActiveException("Client is shutting down", exception));
            return;
        }
        if (this.shouldThrowOfflineException(exception)) {
            this.clientInvocationFuture.complete(new HazelcastClientOfflineException("Client is offline"));
            return;
        }
        if (this.isNotAllowedToRetryOnSelection(exception)) {
            this.completeExceptionally(exception);
            return;
        }
        boolean bl = retry = ClientInvocation.isRetrySafeException(exception) || this.invocationService.isRedoOperation() || exception instanceof TargetDisconnectedException && this.clientMessage.isRetryable();
        if (!retry) {
            this.completeExceptionally(exception);
            return;
        }
        long timePassed = System.currentTimeMillis() - this.startTimeMillis;
        if (timePassed > this.invocationTimeoutMillis) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Exception will not be retried because invocation timed out", exception);
            }
            this.completeExceptionally(this.newOperationTimeoutException(exception));
            return;
        }
        try {
            this.execute();
        }
        catch (RejectedExecutionException e) {
            this.completeExceptionally(new HazelcastClientNotActiveException("Client is shutting down", exception));
        }
    }

    private boolean shouldThrowOfflineException(Throwable exception) {
        return ClientConnectionStrategyConfig.ReconnectMode.ASYNC.equals((Object)this.invocationService.getReconnectMode()) && exception instanceof IOException && !this.clusterConnectorService.mainConnectionExists();
    }

    private void logException(Throwable exception) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Invocation got an exception " + this + ", invoke count : " + this.invokeCount + ", exception : " + exception.getClass() + ", message : " + exception.getMessage() + (exception.getCause() != null ? ", cause :" + exception.getCause() : ""));
        }
    }

    private void execute() {
        this.invocationService.deRegisterInvocation(this.clientMessage.getCorrelationId());
        if (this.invokeCount < 5L) {
            this.executionService.execute(this);
        } else {
            long delayMillis = Math.min((long)(1 << (int)(this.invokeCount - 5L)), this.retryPauseMillis);
            this.executionService.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    private boolean isNotAllowedToRetryOnSelection(Throwable exception) {
        if (this.isBindToSingleConnection() && (exception instanceof IOException || exception instanceof TargetDisconnectedException)) {
            return true;
        }
        return this.address != null && exception instanceof TargetNotMemberException && this.clientClusterService.getMember(this.address) == null;
    }

    private boolean isBindToSingleConnection() {
        return this.connection != null;
    }

    EventHandler getEventHandler() {
        return this.handler;
    }

    public void setEventHandler(EventHandler handler) {
        this.handler = handler;
    }

    public void setSendConnection(ClientConnection connection) {
        this.sendConnection = connection;
    }

    public ClientConnection getSendConnectionOrWait() throws InterruptedException {
        while (this.sendConnection == null && !this.clientInvocationFuture.isDone()) {
            Thread.sleep(this.retryPauseMillis);
        }
        return this.sendConnection;
    }

    public ClientConnection getSendConnection() {
        return this.sendConnection;
    }

    public static boolean isRetrySafeException(Throwable t) {
        return t instanceof IOException || t instanceof HazelcastInstanceNotActiveException || t instanceof RetryableException;
    }

    public Executor getUserExecutor() {
        return this.executionService.getUserExecutor();
    }

    private Exception newOperationTimeoutException(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(this);
        sb.append(" timed out because exception occurred after client invocation timeout ");
        sb.append(this.invocationService.getInvocationTimeoutMillis()).append(" ms. ");
        sb.append("Current time: ").append(StringUtil.timeToString(Clock.currentTimeMillis())).append(". ");
        sb.append("Start time: ").append(StringUtil.timeToString(this.startTimeMillis)).append(". ");
        sb.append("Total elapsed time: ").append(Clock.currentTimeMillis() - this.startTimeMillis).append(" ms. ");
        String msg = sb.toString();
        return new OperationTimeoutException(msg, e);
    }

    public String toString() {
        String target = this.isBindToSingleConnection() ? "connection " + this.connection : (this.partitionId != -1 ? "partition " + this.partitionId : (this.address != null ? "address " + this.address : "random"));
        return "ClientInvocation{clientMessage = " + this.clientMessage + ", objectName = " + this.objectName + ", target = " + target + ", sendConnection = " + this.sendConnection + '}';
    }
}

