/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddPartitionListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ClientGetPartitionsCodec;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.impl.spi.impl.listener.AbstractClientListenerService;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.internal.cluster.impl.MemberSelectingCollection;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.partition.Partition;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public final class ClientPartitionServiceImpl
implements ClientPartitionService {
    private static final long PERIOD = 10L;
    private static final long INITIAL_DELAY = 10L;
    private static final long BLOCKING_GET_ONCE_SLEEP_MILLIS = 100L;
    private final BiConsumer<ClientMessage, Throwable> refreshTaskCallback = new RefreshTaskCallback();
    private final ClientExecutionServiceImpl clientExecutionService;
    private final HazelcastClientInstanceImpl client;
    private final ILogger logger;
    private final AtomicReference<PartitionTable> partitionTable = new AtomicReference<PartitionTable>(new PartitionTable(null, -1, new Int2ObjectHashMap<Address>()));
    private volatile int partitionCount;
    private volatile long lastCorrelationId = -1L;

    public ClientPartitionServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(ClientPartitionService.class);
        this.clientExecutionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
    }

    public void start() {
        this.clientExecutionService.scheduleWithRepetition(new RefreshTask(), 10L, 10L, TimeUnit.SECONDS);
    }

    public void listenPartitionTable(Connection connection) throws Exception {
        Int2ObjectHashMap<Address> partitions = this.getPartitions();
        this.partitionTable.set(new PartitionTable(connection, -1, partitions));
        ClientMessage clientMessage = ClientAddPartitionListenerCodec.encodeRequest();
        ClientInvocation invocation = new ClientInvocation(this.client, clientMessage, null, connection);
        invocation.setEventHandler(new PartitionEventHandler(connection));
        invocation.invokeUrgent().get();
        this.lastCorrelationId = clientMessage.getCorrelationId();
    }

    public void cleanupOnDisconnect() {
        ((AbstractClientListenerService)this.client.getListenerService()).removeEventHandler(this.lastCorrelationId);
    }

    void refreshPartitions() {
        try {
            this.clientExecutionService.execute(new RefreshTask());
        }
        catch (RejectedExecutionException ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    private void waitForPartitionCountSetOnce() {
        while (this.partitionCount == 0 && this.client.getConnectionManager().isAlive()) {
            ClientClusterService clusterService = this.client.getClientClusterService();
            Collection<Member> memberList = clusterService.getMemberList();
            Connection currentOwnerConnection = this.partitionTable.get().connection;
            if (memberList.isEmpty() || currentOwnerConnection == null) {
                this.sleepBeforeNextTry();
                continue;
            }
            if (this.isClusterFormedByOnlyLiteMembers(memberList)) {
                throw new NoDataMemberInClusterException("Partitions can't be assigned since all nodes in the cluster are lite members");
            }
            ClientMessage requestMessage = ClientGetPartitionsCodec.encodeRequest();
            ClientInvocationFuture future = new ClientInvocation(this.client, requestMessage, null, currentOwnerConnection).invokeUrgent();
            try {
                ClientMessage responseMessage = (ClientMessage)future.get();
                ClientGetPartitionsCodec.ResponseParameters response = ClientGetPartitionsCodec.decodeResponse(responseMessage);
                Connection connection = responseMessage.getConnection();
                this.processPartitionResponse(connection, response.partitions, response.partitionStateVersion);
            }
            catch (Exception e) {
                if (!this.client.getLifecycleService().isRunning()) continue;
                this.logger.warning("Error while fetching cluster partition table!", e);
            }
        }
    }

    private void sleepBeforeNextTry() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow(e);
        }
    }

    private boolean isClusterFormedByOnlyLiteMembers(Collection<Member> memberList) {
        return MemberSelectingCollection.count(memberList, MemberSelectors.DATA_MEMBER_SELECTOR) == 0;
    }

    private void processPartitionResponse(Connection connection, Collection<Map.Entry<Address, List<Integer>>> partitions, int partitionStateVersion) {
        Int2ObjectHashMap<Address> newPartitions;
        PartitionTable newMetaData;
        PartitionTable current;
        do {
            if (this.shouldBeApplied(connection, partitions, partitionStateVersion, current = this.partitionTable.get())) continue;
            return;
        } while (!this.partitionTable.compareAndSet(current, newMetaData = new PartitionTable(connection, partitionStateVersion, newPartitions = this.convertToPartitionToAddressMap(partitions))));
        if (this.partitionCount == 0) {
            this.partitionCount = newPartitions.size();
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Processed partition response. partitionStateVersion : " + partitionStateVersion + ", partitionCount :" + newPartitions.size() + ", connection : " + connection);
        }
    }

    private boolean shouldBeApplied(Connection connection, Collection<Map.Entry<Address, List<Integer>>> partitions, int partitionStateVersion, PartitionTable current) {
        if (partitions.isEmpty()) {
            if (this.logger.isFinestEnabled()) {
                this.logFailure(connection, partitionStateVersion, current, "response is empty");
            }
            return false;
        }
        if (!connection.equals(current.connection)) {
            if (this.logger.isFinestEnabled()) {
                this.logFailure(connection, partitionStateVersion, current, "response is from old connection");
            }
            return false;
        }
        if (partitionStateVersion <= current.partitionSateVersion) {
            if (this.logger.isFinestEnabled()) {
                this.logFailure(connection, partitionStateVersion, current, "response state version is old");
            }
            return false;
        }
        return true;
    }

    private void logFailure(Connection connection, int partitionStateVersion, PartitionTable current, String cause) {
        this.logger.finest(" We will not apply the response, since " + cause + " . Response is from " + connection + ". Current connection " + current.connection + " response state version:" + partitionStateVersion + ". Current state version: " + current.partitionSateVersion);
    }

    private Int2ObjectHashMap<Address> convertToPartitionToAddressMap(Collection<Map.Entry<Address, List<Integer>>> partitions) {
        Int2ObjectHashMap<Address> newPartitions = new Int2ObjectHashMap<Address>();
        for (Map.Entry<Address, List<Integer>> entry : partitions) {
            Address address = entry.getKey();
            for (Integer partition : entry.getValue()) {
                newPartitions.put(partition, address);
            }
        }
        return newPartitions;
    }

    @Override
    public void reset() {
        this.partitionTable.set(new PartitionTable(null, -1, new Int2ObjectHashMap<Address>()));
    }

    @Override
    public Address getPartitionOwner(int partitionId) {
        return this.getPartitions().get(partitionId);
    }

    private Int2ObjectHashMap<Address> getPartitions() {
        return this.partitionTable.get().partitions;
    }

    @Override
    public int getPartitionId(Data key) {
        int pc = this.getPartitionCount();
        if (pc <= 0) {
            return 0;
        }
        int hash = key.getPartitionHash();
        return HashUtil.hashToIndex(hash, pc);
    }

    @Override
    public int getPartitionId(Object key) {
        Object data = this.client.getSerializationService().toData(key);
        return this.getPartitionId((Data)data);
    }

    @Override
    public int getPartitionCount() {
        if (this.partitionCount == 0) {
            this.waitForPartitionCountSetOnce();
        }
        return this.partitionCount;
    }

    @Override
    public Partition getPartition(int partitionId) {
        return new PartitionImpl(partitionId);
    }

    private class RefreshTaskCallback
    implements BiConsumer<ClientMessage, Throwable> {
        private RefreshTaskCallback() {
        }

        @Override
        public void accept(ClientMessage responseMessage, Throwable throwable) {
            if (throwable == null) {
                if (responseMessage == null) {
                    return;
                }
                Connection connection = responseMessage.getConnection();
                ClientGetPartitionsCodec.ResponseParameters response = ClientGetPartitionsCodec.decodeResponse(responseMessage);
                ClientPartitionServiceImpl.this.processPartitionResponse(connection, response.partitions, response.partitionStateVersion);
            } else if (ClientPartitionServiceImpl.this.client.getLifecycleService().isRunning()) {
                ClientPartitionServiceImpl.this.logger.warning("Error while fetching cluster partition table!", throwable);
            }
        }
    }

    private final class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            block3: {
                try {
                    Connection connection = ((PartitionTable)((ClientPartitionServiceImpl)ClientPartitionServiceImpl.this).partitionTable.get()).connection;
                    if (connection == null) {
                        return;
                    }
                    ClientMessage requestMessage = ClientGetPartitionsCodec.encodeRequest();
                    ClientInvocationFuture future = new ClientInvocation(ClientPartitionServiceImpl.this.client, requestMessage, null, connection).invokeUrgent();
                    future.whenCompleteAsync(ClientPartitionServiceImpl.this.refreshTaskCallback);
                }
                catch (Exception e) {
                    if (!ClientPartitionServiceImpl.this.client.getLifecycleService().isRunning()) break block3;
                    ClientPartitionServiceImpl.this.logger.warning("Error while fetching cluster partition table!", e);
                }
            }
        }
    }

    private final class PartitionEventHandler
    extends ClientAddPartitionListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final Connection clientConnection;

        private PartitionEventHandler(Connection clientConnection) {
            this.clientConnection = clientConnection;
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }

        @Override
        public void handlePartitionsEvent(Collection<Map.Entry<Address, List<Integer>>> partitions, int partitionStateVersion) {
            ClientPartitionServiceImpl.this.processPartitionResponse(this.clientConnection, partitions, partitionStateVersion);
        }
    }

    private final class PartitionImpl
    implements Partition {
        private final int partitionId;

        private PartitionImpl(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            Address owner = ClientPartitionServiceImpl.this.getPartitionOwner(this.partitionId);
            if (owner != null) {
                return ClientPartitionServiceImpl.this.client.getClientClusterService().getMember(owner);
            }
            return null;
        }

        public String toString() {
            return "PartitionImpl{partitionId=" + this.partitionId + '}';
        }
    }

    private static class PartitionTable {
        final Connection connection;
        final int partitionSateVersion;
        final Int2ObjectHashMap<Address> partitions;

        PartitionTable(Connection connection, int partitionSateVersion, Int2ObjectHashMap<Address> partitions) {
            this.connection = connection;
            this.partitionSateVersion = partitionSateVersion;
            this.partitions = partitions;
        }
    }
}

