/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.proxy.txn.TransactionContextProxy;
import com.hazelcast.client.impl.proxy.txn.xa.XATransactionContextProxy;
import com.hazelcast.client.impl.spi.ClientTransactionManagerService;
import com.hazelcast.client.impl.spi.impl.AbstractClientInvocationService;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.xa.Xid;

public class ClientTransactionManagerServiceImpl
implements ClientTransactionManagerService {
    private final HazelcastClientInstanceImpl client;
    private final LoadBalancer loadBalancer;

    public ClientTransactionManagerServiceImpl(HazelcastClientInstanceImpl client, LoadBalancer loadBalancer) {
        this.client = client;
        this.loadBalancer = loadBalancer;
    }

    public HazelcastClientInstanceImpl getClient() {
        return this.client;
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.newTransactionContext(TransactionOptions.getDefault());
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return new TransactionContextProxy(this, options);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.executeTransaction(TransactionOptions.getDefault(), task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        TransactionContext context = this.newTransactionContext(options);
        context.beginTransaction();
        try {
            T value = task.execute(context);
            context.commitTransaction();
            return value;
        }
        catch (Throwable e) {
            context.rollbackTransaction();
            if (e instanceof TransactionException) {
                throw (TransactionException)e;
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionException(e);
        }
    }

    @Override
    public TransactionContext newXATransactionContext(Xid xid, int timeoutInSeconds) {
        return new XATransactionContextProxy(this, xid, timeoutInSeconds);
    }

    public void shutdown() {
    }

    @Override
    public String getClientName() {
        return this.client.getClientConfig().getClientName();
    }

    public ClientConnection connect() throws Exception {
        AbstractClientInvocationService invocationService = (AbstractClientInvocationService)this.client.getInvocationService();
        long startTimeMillis = System.currentTimeMillis();
        long invocationTimeoutMillis = invocationService.getInvocationTimeoutMillis();
        ClientConfig clientConfig = this.client.getClientConfig();
        boolean smartRouting = clientConfig.getNetworkConfig().isSmartRouting();
        while (this.client.getLifecycleService().isRunning()) {
            try {
                if (smartRouting) {
                    return this.tryConnectSmart();
                }
                return this.tryConnectUnisocket();
            }
            catch (Exception e) {
                if (e instanceof HazelcastClientOfflineException) {
                    throw e;
                }
                if (System.currentTimeMillis() - startTimeMillis > invocationTimeoutMillis) {
                    throw this.newOperationTimeoutException(e, invocationTimeoutMillis, startTimeMillis);
                }
                Thread.sleep(invocationService.getInvocationRetryPauseMillis());
            }
        }
        throw new HazelcastClientNotActiveException("Client is shutdown");
    }

    private Exception newOperationTimeoutException(Throwable e, long invocationTimeoutMillis, long startTimeMillis) {
        StringBuilder sb = new StringBuilder();
        sb.append("Creating transaction context timed out because exception occurred after client invocation timeout ");
        sb.append(invocationTimeoutMillis).append(" ms. ");
        sb.append("Current time: ").append(StringUtil.timeToString(Clock.currentTimeMillis())).append(". ");
        sb.append("Start time: ").append(StringUtil.timeToString(startTimeMillis)).append(". ");
        sb.append("Total elapsed time: ").append(Clock.currentTimeMillis() - startTimeMillis).append(" ms. ");
        String msg = sb.toString();
        return new OperationTimeoutException(msg, e);
    }

    private ClientConnection tryConnectUnisocket() {
        Iterator<ClientConnection> iterator = this.client.getConnectionManager().getActiveConnections().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return this.throwException(false);
    }

    private ClientConnection throwException(boolean smartRouting) {
        ClientConfig clientConfig = this.client.getClientConfig();
        ClientConnectionStrategyConfig connectionStrategyConfig = clientConfig.getConnectionStrategyConfig();
        ClientConnectionStrategyConfig.ReconnectMode reconnectMode = connectionStrategyConfig.getReconnectMode();
        if (reconnectMode.equals((Object)ClientConnectionStrategyConfig.ReconnectMode.ASYNC)) {
            throw new HazelcastClientOfflineException("Hazelcast client is offline");
        }
        if (smartRouting) {
            Set<Member> members = this.client.getCluster().getMembers();
            String msg = members.isEmpty() ? "No address was return by the LoadBalancer since there are no members in the cluster" : "No address was return by the LoadBalancer. But the cluster contains the following members:" + members;
            throw new IllegalStateException(msg);
        }
        throw new IllegalStateException("No active connection is found");
    }

    private ClientConnection tryConnectSmart() throws IOException {
        Address address = this.getRandomAddress();
        if (address == null) {
            this.throwException(true);
        }
        return (ClientConnection)this.client.getConnectionManager().getOrConnect(address);
    }

    private Address getRandomAddress() {
        Member member = this.loadBalancer.next();
        if (member == null) {
            return null;
        }
        return member.getAddress();
    }
}

