/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

@SerializableByConvention(value=SerializableByConvention.Reason.PUBLIC_API)
@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public class MemberAttributeEvent
extends MembershipEvent
implements DataSerializable {
    private MemberAttributeOperationType operationType;
    private String key;
    private Object value;

    public MemberAttributeEvent() {
        super(null, null, 5, Collections.EMPTY_SET);
    }

    public MemberAttributeEvent(Cluster cluster, Member member, Set<Member> members, MemberAttributeOperationType operationType, String key, Object value) {
        super(cluster, member, 5, members);
        this.member = member;
        this.operationType = operationType;
        this.key = key;
        this.value = value;
    }

    public MemberAttributeOperationType getOperationType() {
        return this.operationType;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.key);
        this.member.writeData(out);
        out.writeByte(this.operationType.getId());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            IOUtil.writeAttributeValue(this.value, out);
        }
        out.writeObject(this.members);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = in.readUTF();
        this.member = new MemberImpl();
        this.member.readData(in);
        this.operationType = MemberAttributeOperationType.getValue(in.readByte());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            this.value = IOUtil.readAttributeValue(in);
        }
        this.source = this.member;
        this.members = Collections.unmodifiableSet((Set)in.readObject());
    }
}

