/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txncollection.operations;

import com.hazelcast.collection.impl.collection.CollectionContainer;
import com.hazelcast.collection.impl.collection.operations.CollectionOperation;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import java.io.IOException;
import java.util.UUID;

public class CollectionReserveRemoveOperation
extends CollectionOperation
implements MutatingOperation {
    private UUID transactionId;
    private Data value;
    private long reservedItemId = -1L;

    public CollectionReserveRemoveOperation() {
    }

    public CollectionReserveRemoveOperation(String name, long reservedItemId, Data value, UUID transactionId) {
        super(name);
        this.reservedItemId = reservedItemId;
        this.value = value;
        this.transactionId = transactionId;
    }

    @Override
    public int getClassId() {
        return 25;
    }

    @Override
    public void run() throws Exception {
        CollectionContainer collectionContainer = this.getOrCreateContainer();
        this.response = collectionContainer.reserveRemove(this.reservedItemId, this.value, this.transactionId);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.reservedItemId);
        out.writeData(this.value);
        UUIDSerializationUtil.writeUUID(out, this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.reservedItemId = in.readLong();
        this.value = in.readData();
        this.transactionId = UUIDSerializationUtil.readUUID(in);
    }
}

