/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class EventJournalConfig
implements IdentifiedDataSerializable {
    public static final int DEFAULT_CAPACITY = 10000;
    public static final int DEFAULT_TTL_SECONDS = 0;
    private boolean enabled;
    private int capacity = 10000;
    private int timeToLiveSeconds = 0;

    public EventJournalConfig() {
    }

    public EventJournalConfig(EventJournalConfig config) {
        Preconditions.checkNotNull(config, "config can't be null");
        this.enabled = config.enabled;
        this.capacity = config.capacity;
        this.timeToLiveSeconds = config.timeToLiveSeconds;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public EventJournalConfig setCapacity(int capacity) {
        Preconditions.checkPositive(capacity, "capacity can't be smaller than 1");
        this.capacity = capacity;
        return this;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public EventJournalConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = Preconditions.checkNotNegative(timeToLiveSeconds, "timeToLiveSeconds can't be smaller than 0");
        return this;
    }

    public String toString() {
        return "EventJournalConfig{enabled=" + this.enabled + ", capacity=" + this.capacity + ", timeToLiveSeconds=" + this.timeToLiveSeconds + '}';
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public EventJournalConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 43;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeInt(this.capacity);
        out.writeInt(this.timeToLiveSeconds);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.capacity = in.readInt();
        this.timeToLiveSeconds = in.readInt();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventJournalConfig)) {
            return false;
        }
        EventJournalConfig that = (EventJournalConfig)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.capacity != that.capacity) {
            return false;
        }
        return this.timeToLiveSeconds == that.timeToLiveSeconds;
    }

    public final int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + this.capacity;
        result = 31 * result + this.timeToLiveSeconds;
        return result;
    }
}

