/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class MerkleTreeConfig
implements IdentifiedDataSerializable {
    private static final int MIN_DEPTH = 2;
    private static final int MAX_DEPTH = 27;
    private static final int DEFAULT_DEPTH = 10;
    private boolean enabled;
    private int depth = 10;

    public MerkleTreeConfig() {
    }

    public MerkleTreeConfig(MerkleTreeConfig config) {
        Preconditions.checkNotNull(config, "config can't be null");
        this.enabled = config.enabled;
        this.depth = config.depth;
    }

    public String toString() {
        return "MerkleTreeConfig{enabled=" + this.enabled + ", depth=" + this.depth + '}';
    }

    public int getDepth() {
        return this.depth;
    }

    public MerkleTreeConfig setDepth(int depth) {
        if (depth < 2 || depth > 27) {
            throw new IllegalArgumentException("Merkle tree depth " + depth + " is outside of the allowed range " + 2 + "-" + 27 + ". ");
        }
        this.depth = depth;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MerkleTreeConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 50;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeInt(this.depth);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.depth = in.readInt();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MerkleTreeConfig)) {
            return false;
        }
        MerkleTreeConfig that = (MerkleTreeConfig)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        return this.depth == that.depth;
    }

    public final int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + this.depth;
        return result;
    }
}

