/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.Preconditions;
import javax.annotation.Nonnull;

public class MetricsConfig {
    public static final int DEFAULT_METRICS_COLLECTION_SECONDS = 5;
    public static final int DEFAULT_METRICS_RETENTION_SECONDS = 5;
    private boolean enabled = true;
    private boolean mcEnabled = true;
    private boolean jmxEnabled = true;
    private int retentionSeconds = 5;
    private boolean metricsForDataStructuresEnabled;
    private int intervalSeconds = 5;
    private ProbeLevel minimumLevel = ProbeLevel.INFO;

    public MetricsConfig() {
    }

    public MetricsConfig(MetricsConfig metricsConfig) {
        this.enabled = metricsConfig.enabled;
        this.mcEnabled = metricsConfig.mcEnabled;
        this.jmxEnabled = metricsConfig.jmxEnabled;
        this.retentionSeconds = metricsConfig.retentionSeconds;
        this.metricsForDataStructuresEnabled = metricsConfig.metricsForDataStructuresEnabled;
        this.intervalSeconds = metricsConfig.intervalSeconds;
        this.minimumLevel = metricsConfig.minimumLevel;
    }

    @Nonnull
    public MetricsConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMcEnabled() {
        return this.mcEnabled;
    }

    public MetricsConfig setMcEnabled(boolean mcEnabled) {
        this.mcEnabled = mcEnabled;
        return this;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public MetricsConfig setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
        return this;
    }

    @Nonnull
    public MetricsConfig setRetentionSeconds(int retentionSeconds) {
        Preconditions.checkPositive(this.intervalSeconds, "retentionSeconds must be positive");
        this.retentionSeconds = retentionSeconds;
        return this;
    }

    public int getRetentionSeconds() {
        return this.retentionSeconds;
    }

    @Nonnull
    public MetricsConfig setCollectionIntervalSeconds(int intervalSeconds) {
        Preconditions.checkPositive(intervalSeconds, "intervalSeconds must be positive");
        this.intervalSeconds = intervalSeconds;
        return this;
    }

    public int getCollectionIntervalSeconds() {
        return this.intervalSeconds;
    }

    @Nonnull
    public MetricsConfig setMetricsForDataStructuresEnabled(boolean metricsForDataStructuresEnabled) {
        this.metricsForDataStructuresEnabled = metricsForDataStructuresEnabled;
        return this.setMinimumLevel(ProbeLevel.INFO);
    }

    public boolean isMetricsForDataStructuresEnabled() {
        return this.metricsForDataStructuresEnabled;
    }

    public MetricsConfig setMinimumLevel(ProbeLevel minimumLevel) {
        this.minimumLevel = minimumLevel;
        return this;
    }

    @Nonnull
    public ProbeLevel getMinimumLevel() {
        return this.minimumLevel;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MetricsConfig)) {
            return false;
        }
        MetricsConfig that = (MetricsConfig)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.mcEnabled != that.mcEnabled) {
            return false;
        }
        if (this.jmxEnabled != that.jmxEnabled) {
            return false;
        }
        if (this.retentionSeconds != that.retentionSeconds) {
            return false;
        }
        if (this.metricsForDataStructuresEnabled != that.metricsForDataStructuresEnabled) {
            return false;
        }
        if (this.intervalSeconds != that.intervalSeconds) {
            return false;
        }
        return this.minimumLevel == that.minimumLevel;
    }

    public final int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.mcEnabled ? 1 : 0);
        result = 31 * result + (this.jmxEnabled ? 1 : 0);
        result = 31 * result + this.retentionSeconds;
        result = 31 * result + (this.metricsForDataStructuresEnabled ? 1 : 0);
        result = 31 * result + this.intervalSeconds;
        result = 31 * result + (this.minimumLevel != null ? this.minimumLevel.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MetricsConfig{enabled=" + this.enabled + ", mcEnabled=" + this.mcEnabled + ", jmxEnabled=" + this.jmxEnabled + ", retentionSeconds=" + this.retentionSeconds + ", metricsForDataStructuresEnabled=" + this.metricsForDataStructuresEnabled + ", intervalSeconds=" + this.intervalSeconds + ", minimumLevel=" + (Object)((Object)this.minimumLevel) + '}';
    }
}

