/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SplitBrainProtectionConfigBuilder;
import com.hazelcast.internal.cluster.fd.PhiAccrualClusterFailureDetector;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.splitbrainprotection.impl.ProbabilisticSplitBrainProtectionFunction;
import java.util.concurrent.TimeUnit;

public class ProbabilisticSplitBrainProtectionConfigBuilder
extends SplitBrainProtectionConfigBuilder {
    public static final double DEFAULT_PHI_THRESHOLD = Double.parseDouble(PhiAccrualClusterFailureDetector.HEARTBEAT_PHI_FAILURE_DETECTOR_THRESHOLD.getDefaultValue());
    public static final int DEFAULT_SAMPLE_SIZE = Integer.parseInt(PhiAccrualClusterFailureDetector.HEARTBEAT_PHI_FAILURE_DETECTOR_SAMPLE_SIZE.getDefaultValue());
    public static final long DEFAULT_MIN_STD_DEVIATION = Long.parseLong(PhiAccrualClusterFailureDetector.HEARTBEAT_PHI_FAILURE_DETECTOR_MIN_STD_DEV_MILLIS.getDefaultValue());
    public static final long DEFAULT_HEARTBEAT_PAUSE_MILLIS = TimeUnit.SECONDS.toMillis(Integer.parseInt(GroupProperty.MAX_NO_HEARTBEAT_SECONDS.getDefaultValue()));
    public static final long DEFAULT_HEARTBEAT_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(Integer.parseInt(GroupProperty.HEARTBEAT_INTERVAL_SECONDS.getDefaultValue()));
    private final String name;
    private double phiThreshold = DEFAULT_PHI_THRESHOLD;
    private int maxSampleSize = DEFAULT_SAMPLE_SIZE;
    private long minStdDeviationMillis = DEFAULT_MIN_STD_DEVIATION;
    private long acceptableHeartbeatPauseMillis = DEFAULT_HEARTBEAT_PAUSE_MILLIS;
    private long heartbeatIntervalMillis = DEFAULT_HEARTBEAT_INTERVAL_MILLIS;

    ProbabilisticSplitBrainProtectionConfigBuilder(String name, int size) {
        this.name = name;
        this.minimumClusterSize = size;
    }

    public ProbabilisticSplitBrainProtectionConfigBuilder withSuspicionThreshold(double suspicionThreshold) {
        this.phiThreshold = suspicionThreshold;
        return this;
    }

    public ProbabilisticSplitBrainProtectionConfigBuilder withMaxSampleSize(int maxSampleSize) {
        this.maxSampleSize = maxSampleSize;
        return this;
    }

    public ProbabilisticSplitBrainProtectionConfigBuilder withMinStdDeviationMillis(long minStdDeviationMillis) {
        this.minStdDeviationMillis = minStdDeviationMillis;
        return this;
    }

    public ProbabilisticSplitBrainProtectionConfigBuilder withAcceptableHeartbeatPauseMillis(long acceptableHeartbeatPauseMillis) {
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPauseMillis;
        return this;
    }

    public ProbabilisticSplitBrainProtectionConfigBuilder withHeartbeatIntervalMillis(long heartbeatIntervalMillis) {
        this.heartbeatIntervalMillis = heartbeatIntervalMillis;
        return this;
    }

    @Override
    public SplitBrainProtectionConfig build() {
        ProbabilisticSplitBrainProtectionFunction splitBrainProtectionFunction = new ProbabilisticSplitBrainProtectionFunction(this.minimumClusterSize, this.heartbeatIntervalMillis, this.acceptableHeartbeatPauseMillis, this.maxSampleSize, this.minStdDeviationMillis, this.phiThreshold);
        SplitBrainProtectionConfig config = new SplitBrainProtectionConfig();
        config.setName(this.name);
        config.setEnabled(this.enabled);
        config.setMinimumClusterSize(this.minimumClusterSize);
        config.setFunctionImplementation(splitBrainProtectionFunction);
        return config;
    }
}

