/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ConfigDataSerializerHook;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.merge.SplitBrainMergeTypeProvider;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.io.IOException;

public class ScheduledExecutorConfig
implements SplitBrainMergeTypeProvider,
IdentifiedDataSerializable,
NamedConfig {
    private static final int DEFAULT_POOL_SIZE = 16;
    private static final int DEFAULT_CAPACITY = 100;
    private static final int DEFAULT_DURABILITY = 1;
    private String name = "default";
    private int durability = 1;
    private int capacity = 100;
    private int poolSize = 16;
    private String splitBrainProtectionName;
    private MergePolicyConfig mergePolicyConfig = new MergePolicyConfig();

    public ScheduledExecutorConfig() {
    }

    public ScheduledExecutorConfig(String name) {
        this.name = name;
    }

    public ScheduledExecutorConfig(String name, int durability, int capacity, int poolSize) {
        this(name, durability, capacity, poolSize, null, new MergePolicyConfig());
    }

    public ScheduledExecutorConfig(String name, int durability, int capacity, int poolSize, String splitBrainProtectionName, MergePolicyConfig mergePolicyConfig) {
        this.name = name;
        this.durability = durability;
        this.poolSize = poolSize;
        this.capacity = capacity;
        this.splitBrainProtectionName = splitBrainProtectionName;
        this.mergePolicyConfig = mergePolicyConfig;
    }

    public ScheduledExecutorConfig(ScheduledExecutorConfig config) {
        this(config.getName(), config.getDurability(), config.getCapacity(), config.getPoolSize(), config.getSplitBrainProtectionName(), config.getMergePolicyConfig());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ScheduledExecutorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public ScheduledExecutorConfig setPoolSize(int poolSize) {
        this.poolSize = Preconditions.checkPositive(poolSize, "Pool size should be greater than 0");
        return this;
    }

    public int getDurability() {
        return this.durability;
    }

    public ScheduledExecutorConfig setDurability(int durability) {
        this.durability = Preconditions.checkNotNegative(durability, "durability can't be smaller than 0");
        return this;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ScheduledExecutorConfig setCapacity(int capacity) {
        this.capacity = Preconditions.checkNotNegative(capacity, "capacity can't be smaller than 0");
        return this;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public ScheduledExecutorConfig setSplitBrainProtectionName(String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return this;
    }

    public MergePolicyConfig getMergePolicyConfig() {
        return this.mergePolicyConfig;
    }

    public ScheduledExecutorConfig setMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mergePolicyConfig = Preconditions.checkNotNull(mergePolicyConfig, "mergePolicyConfig cannot be null");
        return this;
    }

    public Class getProvidedMergeTypes() {
        return SplitBrainMergeTypes.ScheduledExecutorMergeTypes.class;
    }

    public String toString() {
        return "ScheduledExecutorConfig{name='" + this.name + '\'' + ", durability=" + this.durability + ", poolSize=" + this.poolSize + ", capacity=" + this.capacity + ", splitBrainProtectionName=" + this.splitBrainProtectionName + ", mergePolicyConfig=" + this.mergePolicyConfig + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 32;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.durability);
        out.writeInt(this.capacity);
        out.writeInt(this.poolSize);
        out.writeUTF(this.splitBrainProtectionName);
        out.writeObject(this.mergePolicyConfig);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.durability = in.readInt();
        this.capacity = in.readInt();
        this.poolSize = in.readInt();
        this.splitBrainProtectionName = in.readUTF();
        this.mergePolicyConfig = (MergePolicyConfig)in.readObject();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledExecutorConfig)) {
            return false;
        }
        ScheduledExecutorConfig that = (ScheduledExecutorConfig)o;
        if (this.durability != that.durability) {
            return false;
        }
        if (this.capacity != that.capacity) {
            return false;
        }
        if (this.poolSize != that.poolSize) {
            return false;
        }
        if (this.splitBrainProtectionName != null ? !this.splitBrainProtectionName.equals(that.splitBrainProtectionName) : that.splitBrainProtectionName != null) {
            return false;
        }
        if (this.mergePolicyConfig != null ? !this.mergePolicyConfig.equals(that.mergePolicyConfig) : that.mergePolicyConfig != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public final int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.durability;
        result = 31 * result + this.capacity;
        result = 31 * result + this.poolSize;
        result = 31 * result + (this.splitBrainProtectionName != null ? this.splitBrainProtectionName.hashCode() : 0);
        result = 31 * result + (this.mergePolicyConfig != null ? this.mergePolicyConfig.hashCode() : 0);
        return result;
    }
}

