/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.OnJoinPermissionOperationName;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.security.ICredentialsFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SecurityConfig {
    private static final boolean DEFAULT_CLIENT_BLOCK_UNMAPPED_ACTIONS = true;
    private boolean enabled;
    private List<SecurityInterceptorConfig> securityInterceptorConfigs = new ArrayList<SecurityInterceptorConfig>();
    private PermissionPolicyConfig clientPolicyConfig = new PermissionPolicyConfig();
    private Set<PermissionConfig> clientPermissionConfigs = new HashSet<PermissionConfig>();
    private Map<String, RealmConfig> realmConfigs = new HashMap<String, RealmConfig>();
    private String memberRealm;
    private String clientRealm;
    private boolean clientBlockUnmappedActions = true;
    private OnJoinPermissionOperationName onJoinPermissionOperation = OnJoinPermissionOperationName.RECEIVE;

    public SecurityConfig addSecurityInterceptorConfig(SecurityInterceptorConfig interceptorConfig) {
        this.securityInterceptorConfigs.add(interceptorConfig);
        return this;
    }

    public List<SecurityInterceptorConfig> getSecurityInterceptorConfigs() {
        return this.securityInterceptorConfigs;
    }

    public SecurityConfig setSecurityInterceptorConfigs(List<SecurityInterceptorConfig> securityInterceptorConfigs) {
        this.securityInterceptorConfigs = securityInterceptorConfigs;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SecurityConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SecurityConfig addClientPermissionConfig(PermissionConfig permissionConfig) {
        this.clientPermissionConfigs.add(permissionConfig);
        return this;
    }

    public SecurityConfig addRealmConfig(String realmName, RealmConfig realmConfig) {
        this.realmConfigs.put(realmName, realmConfig);
        return this;
    }

    public RealmConfig getRealmConfig(String realmName) {
        return realmName == null ? null : this.realmConfigs.get(realmName);
    }

    public PermissionPolicyConfig getClientPolicyConfig() {
        return this.clientPolicyConfig;
    }

    public SecurityConfig setClientPolicyConfig(PermissionPolicyConfig policyConfig) {
        this.clientPolicyConfig = policyConfig;
        return this;
    }

    public Set<PermissionConfig> getClientPermissionConfigs() {
        return this.clientPermissionConfigs;
    }

    public SecurityConfig setClientPermissionConfigs(Set<PermissionConfig> permissions) {
        this.clientPermissionConfigs = permissions;
        return this;
    }

    public ICredentialsFactory getRealmCredentialsFactory(String realmName) {
        return this.getRealmConfigOrDefault(realmName).asCredentialsFactory();
    }

    public LoginModuleConfig[] getRealmLoginModuleConfigs(String realmName) {
        return this.getRealmConfigOrDefault(realmName).asLoginModuleConfigs();
    }

    public OnJoinPermissionOperationName getOnJoinPermissionOperation() {
        return this.onJoinPermissionOperation;
    }

    public SecurityConfig setOnJoinPermissionOperation(OnJoinPermissionOperationName onJoinPermissionOperation) {
        this.onJoinPermissionOperation = Preconditions.checkNotNull(onJoinPermissionOperation, "Existing " + OnJoinPermissionOperationName.class.getSimpleName() + " value has to be provided.");
        return this;
    }

    public Map<String, RealmConfig> getRealmConfigs() {
        return this.realmConfigs;
    }

    public void setRealmConfigs(Map<String, RealmConfig> realmConfigs) {
        this.realmConfigs = realmConfigs;
    }

    public String getMemberRealm() {
        return this.memberRealm;
    }

    public SecurityConfig setMemberRealm(String memberRealm) {
        this.memberRealm = memberRealm;
        return this;
    }

    public String getClientRealm() {
        return this.clientRealm;
    }

    public SecurityConfig setClientRealm(String clientRealm) {
        this.clientRealm = clientRealm;
        return this;
    }

    public SecurityConfig setMemberRealmConfig(String realmName, RealmConfig realmConfig) {
        this.addRealmConfig(realmName, realmConfig);
        this.setMemberRealm(realmName);
        return this;
    }

    public SecurityConfig setClientRealmConfig(String realmName, RealmConfig realmConfig) {
        this.addRealmConfig(realmName, realmConfig);
        this.setClientRealm(realmName);
        return this;
    }

    public boolean getClientBlockUnmappedActions() {
        return this.clientBlockUnmappedActions;
    }

    public SecurityConfig setClientBlockUnmappedActions(boolean clientBlockUnmappedActions) {
        this.clientBlockUnmappedActions = clientBlockUnmappedActions;
        return this;
    }

    public String toString() {
        return "SecurityConfig [enabled=" + this.enabled + ", securityInterceptorConfigs=" + this.securityInterceptorConfigs + ", clientPolicyConfig=" + this.clientPolicyConfig + ", clientPermissionConfigs=" + this.clientPermissionConfigs + ", realmConfigs=" + this.realmConfigs + ", memberRealm=" + this.memberRealm + ", clientRealm=" + this.clientRealm + ", clientBlockUnmappedActions=" + this.clientBlockUnmappedActions + ", onJoinPermissionOperation=" + (Object)((Object)this.onJoinPermissionOperation) + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientBlockUnmappedActions, this.clientPermissionConfigs, this.clientPolicyConfig, this.clientRealm, this.enabled, this.memberRealm, this.onJoinPermissionOperation, this.realmConfigs, this.securityInterceptorConfigs});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityConfig other = (SecurityConfig)obj;
        return this.clientBlockUnmappedActions == other.clientBlockUnmappedActions && Objects.equals(this.clientPermissionConfigs, other.clientPermissionConfigs) && Objects.equals(this.clientPolicyConfig, other.clientPolicyConfig) && Objects.equals(this.clientRealm, other.clientRealm) && this.enabled == other.enabled && Objects.equals(this.memberRealm, other.memberRealm) && this.onJoinPermissionOperation == other.onJoinPermissionOperation && Objects.equals(this.realmConfigs, other.realmConfigs) && Objects.equals(this.securityInterceptorConfigs, other.securityInterceptorConfigs);
    }

    private RealmConfig getRealmConfigOrDefault(String realmName) {
        RealmConfig realmConfig = realmName == null ? null : this.realmConfigs.get(realmName);
        return realmConfig == null ? RealmConfig.DEFAULT_REALM : realmConfig;
    }
}

