/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.internal.datastructures.spi.RaftRemoteService;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.cp.session.CPSessionManagementService;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;

public class CPSubsystemImpl
implements CPSubsystem {
    private final HazelcastInstanceImpl instance;
    private final boolean cpSubsystemEnabled;

    public CPSubsystemImpl(HazelcastInstanceImpl instance) {
        this.instance = instance;
        int cpMemberCount = instance.getConfig().getCPSubsystemConfig().getCPMemberCount();
        this.cpSubsystemEnabled = cpMemberCount > 0;
        ILogger logger = instance.node.getLogger(CPSubsystem.class);
        if (this.cpSubsystemEnabled) {
            logger.info("CP Subsystem is enabled with " + cpMemberCount + " members.");
        } else {
            logger.warning("CP Subsystem is not enabled. CP data structures will operate in UNSAFE mode! Please note that UNSAFE mode will not provide strong consistency guarantees.");
        }
    }

    @Override
    public IAtomicLong getAtomicLong(String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic long instance with a null name is not allowed!");
        return (IAtomicLong)this.createProxy("hz:raft:atomicLongService", name);
    }

    @Override
    public <E> IAtomicReference<E> getAtomicReference(String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic reference instance with a null name is not allowed!");
        return (IAtomicReference)this.createProxy("hz:raft:atomicRefService", name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        Preconditions.checkNotNull(name, "Retrieving a count down latch instance with a null name is not allowed!");
        return (ICountDownLatch)this.createProxy("hz:raft:countDownLatchService", name);
    }

    @Override
    public FencedLock getLock(String name) {
        Preconditions.checkNotNull(name, "Retrieving an fenced lock instance with a null name is not allowed!");
        return (FencedLock)this.createProxy("hz:raft:lockService", name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        Preconditions.checkNotNull(name, "Retrieving a semaphore instance with a null name is not allowed!");
        return (ISemaphore)this.createProxy("hz:raft:semaphoreService", name);
    }

    @Override
    public CPMember getLocalCPMember() {
        return this.getCPSubsystemManagementService().getLocalCPMember();
    }

    @Override
    public CPSubsystemManagementService getCPSubsystemManagementService() {
        if (!this.cpSubsystemEnabled) {
            throw new HazelcastException("CP Subsystem is not enabled!");
        }
        return (CPSubsystemManagementService)this.getService("hz:core:raft");
    }

    @Override
    public CPSessionManagementService getCPSessionManagementService() {
        if (!this.cpSubsystemEnabled) {
            throw new HazelcastException("CP Subsystem is not enabled!");
        }
        return (CPSessionManagementService)this.getService("hz:core:raftSession");
    }

    private <T> T getService(String serviceName) {
        return this.instance.node.getNodeEngine().getService(serviceName);
    }

    private <T extends DistributedObject> T createProxy(String serviceName, String name) {
        RaftRemoteService service = (RaftRemoteService)this.getService(serviceName);
        return service.createProxy(name);
    }
}

