/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cluster.Address;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.RaftInvocationManager;
import com.hazelcast.cp.internal.RaftNodeLifecycleAwareService;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.operation.integration.AppendFailureResponseOp;
import com.hazelcast.cp.internal.operation.integration.AppendRequestOp;
import com.hazelcast.cp.internal.operation.integration.AppendSuccessResponseOp;
import com.hazelcast.cp.internal.operation.integration.AsyncRaftOp;
import com.hazelcast.cp.internal.operation.integration.InstallSnapshotOp;
import com.hazelcast.cp.internal.operation.integration.PreVoteRequestOp;
import com.hazelcast.cp.internal.operation.integration.PreVoteResponseOp;
import com.hazelcast.cp.internal.operation.integration.TriggerLeaderElectionOp;
import com.hazelcast.cp.internal.operation.integration.VoteRequestOp;
import com.hazelcast.cp.internal.operation.integration.VoteResponseOp;
import com.hazelcast.cp.internal.raft.SnapshotAwareService;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftIntegration;
import com.hazelcast.cp.internal.raft.impl.RaftNodeStatus;
import com.hazelcast.cp.internal.raft.impl.dto.AppendFailureResponse;
import com.hazelcast.cp.internal.raft.impl.dto.AppendRequest;
import com.hazelcast.cp.internal.raft.impl.dto.AppendSuccessResponse;
import com.hazelcast.cp.internal.raft.impl.dto.InstallSnapshot;
import com.hazelcast.cp.internal.raft.impl.dto.PreVoteRequest;
import com.hazelcast.cp.internal.raft.impl.dto.PreVoteResponse;
import com.hazelcast.cp.internal.raft.impl.dto.TriggerLeaderElection;
import com.hazelcast.cp.internal.raft.impl.dto.VoteRequest;
import com.hazelcast.cp.internal.raft.impl.dto.VoteResponse;
import com.hazelcast.cp.internal.raftop.NotifyTermChangeOp;
import com.hazelcast.cp.internal.raftop.snapshot.RestoreSnapshotOp;
import com.hazelcast.cp.internal.util.PartitionSpecificRunnableAdaptor;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.impl.operationexecutor.impl.OperationExecutorImpl;
import com.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.servicemanager.ServiceInfo;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class NodeEngineRaftIntegration
implements RaftIntegration {
    public static final HazelcastProperty RAFT_LINEARIZABLE_READ_OPTIMIZATION_ENABLED = new HazelcastProperty("raft.linearizable.read.optimization.enabled", true);
    private final NodeEngineImpl nodeEngine;
    private final CPGroupId groupId;
    private final RaftEndpoint localCPMember;
    private final Address localAddress;
    private final OperationServiceImpl operationService;
    private final RaftInvocationManager invocationManager;
    private final TaskScheduler taskScheduler;
    private final int partitionId;
    private final int threadId;
    private final boolean linearizableReadOptimizationEnabled;

    NodeEngineRaftIntegration(NodeEngineImpl nodeEngine, CPGroupId groupId, RaftEndpoint localCPMember, int partitionId) {
        this.nodeEngine = nodeEngine;
        this.groupId = groupId;
        this.localCPMember = localCPMember;
        this.localAddress = nodeEngine.getThisAddress();
        this.operationService = nodeEngine.getOperationService();
        this.invocationManager = ((RaftService)nodeEngine.getService("hz:core:raft")).getInvocationManager();
        this.partitionId = partitionId;
        OperationExecutorImpl operationExecutor = (OperationExecutorImpl)this.operationService.getOperationExecutor();
        this.threadId = operationExecutor.toPartitionThreadIndex(partitionId);
        this.taskScheduler = nodeEngine.getExecutionService().getGlobalTaskScheduler();
        this.linearizableReadOptimizationEnabled = nodeEngine.getProperties().getBoolean(RAFT_LINEARIZABLE_READ_OPTIMIZATION_ENABLED);
    }

    @Override
    public void execute(Runnable task) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof PartitionOperationThread && ((PartitionOperationThread)currentThread).getThreadId() == this.threadId) {
            task.run();
        } else {
            this.operationService.execute(new PartitionSpecificRunnableAdaptor(task, this.partitionId));
        }
    }

    @Override
    public void submit(Runnable task) {
        this.operationService.execute(new PartitionSpecificRunnableAdaptor(task, this.partitionId));
    }

    @Override
    public void schedule(Runnable task, long delay, TimeUnit timeUnit) {
        this.taskScheduler.schedule(() -> this.execute(task), delay, timeUnit);
    }

    @Override
    public InternalCompletableFuture newCompletableFuture() {
        return new InternalCompletableFuture();
    }

    @Override
    public Object getAppendedEntryOnLeaderElection() {
        return new NotifyTermChangeOp();
    }

    @Override
    public boolean isLinearizableReadOptimizationEnabled() {
        return this.linearizableReadOptimizationEnabled;
    }

    @Override
    public ILogger getLogger(String name) {
        return this.nodeEngine.getLogger(name);
    }

    @Override
    public boolean isReady() {
        return this.nodeEngine.getClusterService().isJoined();
    }

    @Override
    public boolean isReachable(RaftEndpoint target) {
        CPMember targetMember = this.getCPMember(target);
        return targetMember != null && this.nodeEngine.getClusterService().getMember(targetMember.getAddress()) != null;
    }

    @Override
    public boolean send(PreVoteRequest request, RaftEndpoint target) {
        return this.send(new PreVoteRequestOp(this.groupId, request), target);
    }

    @Override
    public boolean send(PreVoteResponse response, RaftEndpoint target) {
        return this.send(new PreVoteResponseOp(this.groupId, response), target);
    }

    @Override
    public boolean send(VoteRequest request, RaftEndpoint target) {
        return this.send(new VoteRequestOp(this.groupId, request), target);
    }

    @Override
    public boolean send(VoteResponse response, RaftEndpoint target) {
        return this.send(new VoteResponseOp(this.groupId, response), target);
    }

    @Override
    public boolean send(AppendRequest request, RaftEndpoint target) {
        return this.send(new AppendRequestOp(this.groupId, request), target);
    }

    @Override
    public boolean send(AppendSuccessResponse response, RaftEndpoint target) {
        return this.send(new AppendSuccessResponseOp(this.groupId, response), target);
    }

    @Override
    public boolean send(AppendFailureResponse response, RaftEndpoint target) {
        return this.send(new AppendFailureResponseOp(this.groupId, response), target);
    }

    @Override
    public boolean send(InstallSnapshot request, RaftEndpoint target) {
        return this.send(new InstallSnapshotOp(this.groupId, request), target);
    }

    @Override
    public boolean send(TriggerLeaderElection request, RaftEndpoint target) {
        return this.send(new TriggerLeaderElectionOp(this.groupId, request), target);
    }

    @Override
    public Object runOperation(Object op, long commitIndex) {
        RaftOp operation = (RaftOp)op;
        operation.setNodeEngine(this.nodeEngine);
        try {
            return operation.run(this.groupId, commitIndex);
        }
        catch (Throwable t) {
            return t;
        }
    }

    @Override
    public Object takeSnapshot(long commitIndex) {
        try {
            ArrayList<RestoreSnapshotOp> snapshotOps = new ArrayList<RestoreSnapshotOp>();
            for (ServiceInfo serviceInfo : this.nodeEngine.getServiceInfos(SnapshotAwareService.class)) {
                SnapshotAwareService service = (SnapshotAwareService)serviceInfo.getService();
                Object snapshot = service.takeSnapshot(this.groupId, commitIndex);
                if (snapshot == null) continue;
                snapshotOps.add(new RestoreSnapshotOp(serviceInfo.getName(), snapshot));
            }
            return snapshotOps;
        }
        catch (Throwable t) {
            return t;
        }
    }

    @Override
    public void restoreSnapshot(Object op, long commitIndex) {
        ILogger logger = this.nodeEngine.getLogger(this.getClass());
        List snapshotOps = (List)op;
        for (RestoreSnapshotOp snapshotOp : snapshotOps) {
            Object result = this.runOperation(snapshotOp, commitIndex);
            if (!(result instanceof Throwable)) continue;
            logger.severe("Restore of " + snapshotOp + " failed...", (Throwable)result);
        }
    }

    private boolean send(AsyncRaftOp operation, RaftEndpoint target) {
        CPMember targetMember = this.getCPMember(target);
        if (targetMember == null || this.localAddress.equals(targetMember.getAddress())) {
            if (this.localCPMember.getUuid().equals(target.getUuid())) {
                throw new IllegalStateException("Cannot send " + operation + " to " + target + " because it's same with the local CP member!");
            }
            return false;
        }
        operation.setTargetEndpoint(target).setPartitionId(this.partitionId);
        return this.operationService.send(operation, targetMember.getAddress());
    }

    @Override
    public CPMember getCPMember(RaftEndpoint target) {
        return this.invocationManager.getCPMember(target);
    }

    @Override
    public void onNodeStatusChange(RaftNodeStatus status) {
        block3: {
            block2: {
                if (status != RaftNodeStatus.TERMINATED) break block2;
                Collection<RaftNodeLifecycleAwareService> services = this.nodeEngine.getServices(RaftNodeLifecycleAwareService.class);
                for (RaftNodeLifecycleAwareService service : services) {
                    service.onRaftGroupDestroyed(this.groupId);
                }
                break block3;
            }
            if (status != RaftNodeStatus.STEPPED_DOWN) break block3;
            Collection<RaftNodeLifecycleAwareService> services = this.nodeEngine.getServices(RaftNodeLifecycleAwareService.class);
            for (RaftNodeLifecycleAwareService service : services) {
                service.onRaftNodeSteppedDown(this.groupId);
            }
        }
    }
}

