/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.spi;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.operation.unsafe.UnsafeSnapshotReplicationOp;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.partition.MigrationAwareService;
import com.hazelcast.spi.partition.MigrationEndpoint;
import com.hazelcast.spi.partition.PartitionMigrationEvent;
import com.hazelcast.spi.partition.PartitionReplicationEvent;
import java.util.Map;

public abstract class AbstractCPMigrationAwareService
implements MigrationAwareService {
    protected final NodeEngineImpl nodeEngine;
    private final boolean cpSubsystemEnabled;

    protected AbstractCPMigrationAwareService(NodeEngine nodeEngine) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.cpSubsystemEnabled = nodeEngine.getConfig().getCPSubsystemConfig().getCPMemberCount() > 0;
    }

    protected abstract int getBackupCount();

    protected abstract Map<CPGroupId, Object> getSnapshotMap(int var1);

    protected abstract void clearPartitionReplica(int var1);

    @Override
    public final Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        if (this.cpSubsystemEnabled) {
            return null;
        }
        if (event.getReplicaIndex() > this.getBackupCount()) {
            return null;
        }
        Map<CPGroupId, Object> snapshotMap = this.getSnapshotMap(event.getPartitionId());
        if (snapshotMap.isEmpty()) {
            return null;
        }
        return new UnsafeSnapshotReplicationOp(snapshotMap);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public final void commitMigration(PartitionMigrationEvent event) {
        int thresholdReplicaIndex;
        if (this.cpSubsystemEnabled) {
            return;
        }
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE && ((thresholdReplicaIndex = event.getNewReplicaIndex()) == -1 || thresholdReplicaIndex > this.getBackupCount())) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    @Override
    public final void rollbackMigration(PartitionMigrationEvent event) {
        int thresholdReplicaIndex;
        if (this.cpSubsystemEnabled) {
            return;
        }
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION && ((thresholdReplicaIndex = event.getCurrentReplicaIndex()) == -1 || thresholdReplicaIndex > this.getBackupCount())) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }
}

