/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.state;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftRole;
import com.hazelcast.cp.internal.raft.impl.dto.VoteRequest;
import com.hazelcast.cp.internal.raft.impl.log.RaftLog;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotEntry;
import com.hazelcast.cp.internal.raft.impl.persistence.NopRaftStateStore;
import com.hazelcast.cp.internal.raft.impl.persistence.RaftStateStore;
import com.hazelcast.cp.internal.raft.impl.persistence.RestoredRaftState;
import com.hazelcast.cp.internal.raft.impl.state.CandidateState;
import com.hazelcast.cp.internal.raft.impl.state.LeaderState;
import com.hazelcast.cp.internal.raft.impl.state.LeadershipTransferState;
import com.hazelcast.cp.internal.raft.impl.state.RaftGroupMembers;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public final class RaftState {
    private final RaftEndpoint localEndpoint;
    private final CPGroupId groupId;
    private final Collection<RaftEndpoint> initialMembers;
    private final RaftStateStore store;
    private RaftGroupMembers committedGroupMembers;
    private RaftGroupMembers lastGroupMembers;
    private RaftRole role = RaftRole.FOLLOWER;
    private int term;
    private volatile RaftEndpoint leader;
    private long commitIndex;
    private long lastApplied;
    private RaftEndpoint votedFor;
    private final RaftLog log;
    private LeaderState leaderState;
    private CandidateState preCandidateState;
    private CandidateState candidateState;
    private LeadershipTransferState leadershipTransferState;

    private RaftState(CPGroupId groupId, RaftEndpoint localEndpoint, Collection<RaftEndpoint> endpoints, int logCapacity, RaftStateStore store) {
        RaftGroupMembers groupMembers;
        this.groupId = groupId;
        this.localEndpoint = localEndpoint;
        this.initialMembers = Collections.unmodifiableSet(new LinkedHashSet<RaftEndpoint>(endpoints));
        this.committedGroupMembers = groupMembers = new RaftGroupMembers(0L, endpoints, localEndpoint);
        this.lastGroupMembers = groupMembers;
        this.store = store;
        this.log = RaftLog.newRaftLog(logCapacity, store);
    }

    private RaftState(CPGroupId groupId, RestoredRaftState restoredState, int logCapacity, RaftStateStore store) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(restoredState);
        Preconditions.checkNotNull(store);
        this.groupId = groupId;
        this.localEndpoint = restoredState.localEndpoint();
        this.initialMembers = Collections.unmodifiableSet(new LinkedHashSet<RaftEndpoint>(restoredState.initialMembers()));
        this.lastGroupMembers = this.committedGroupMembers = new RaftGroupMembers(0L, this.initialMembers, this.localEndpoint);
        this.term = restoredState.term();
        this.votedFor = restoredState.votedFor();
        SnapshotEntry snapshot = restoredState.snapshot();
        if (SnapshotEntry.isNonInitial(snapshot)) {
            RaftGroupMembers groupMembers;
            this.committedGroupMembers = groupMembers = new RaftGroupMembers(snapshot.groupMembersLogIndex(), snapshot.groupMembers(), this.localEndpoint);
            this.lastGroupMembers = groupMembers;
            this.commitIndex = snapshot.index();
            this.lastApplied = snapshot.index();
        }
        this.log = RaftLog.restoreRaftLog(logCapacity, snapshot, restoredState.entries(), store);
        this.store = store;
    }

    public static RaftState newRaftState(CPGroupId groupId, RaftEndpoint localEndpoint, Collection<RaftEndpoint> endpoints, int logCapacity) {
        return RaftState.newRaftState(groupId, localEndpoint, endpoints, logCapacity, NopRaftStateStore.INSTANCE);
    }

    public static RaftState newRaftState(CPGroupId groupId, RaftEndpoint localEndpoint, Collection<RaftEndpoint> endpoints, int logCapacity, RaftStateStore stateStore) {
        return new RaftState(groupId, localEndpoint, endpoints, logCapacity, stateStore);
    }

    public static RaftState restoreRaftState(CPGroupId groupId, RestoredRaftState restoredState, int logCapacity) {
        return RaftState.restoreRaftState(groupId, restoredState, logCapacity, NopRaftStateStore.INSTANCE);
    }

    public static RaftState restoreRaftState(CPGroupId groupId, RestoredRaftState restoredState, int logCapacity, RaftStateStore stateStore) {
        return new RaftState(groupId, restoredState, logCapacity, stateStore);
    }

    public String name() {
        return this.groupId.getName();
    }

    public CPGroupId groupId() {
        return this.groupId;
    }

    public RaftEndpoint localEndpoint() {
        return this.localEndpoint;
    }

    public Collection<RaftEndpoint> initialMembers() {
        return this.initialMembers;
    }

    public Collection<RaftEndpoint> members() {
        return this.lastGroupMembers.members();
    }

    public Collection<RaftEndpoint> remoteMembers() {
        return this.lastGroupMembers.remoteMembers();
    }

    public int memberCount() {
        return this.lastGroupMembers.memberCount();
    }

    public int majority() {
        return this.lastGroupMembers.majority();
    }

    public long membersLogIndex() {
        return this.lastGroupMembers.index();
    }

    public RaftGroupMembers committedGroupMembers() {
        return this.committedGroupMembers;
    }

    public RaftGroupMembers lastGroupMembers() {
        return this.lastGroupMembers;
    }

    public RaftRole role() {
        return this.role;
    }

    public int term() {
        return this.term;
    }

    public RaftStateStore stateStore() {
        return this.store;
    }

    public RaftEndpoint leader() {
        return this.leader;
    }

    public RaftEndpoint votedFor() {
        return this.votedFor;
    }

    public void init() throws IOException {
        this.store.open();
        this.store.persistInitialMembers(this.localEndpoint, this.initialMembers);
    }

    public void leader(RaftEndpoint endpoint) {
        this.leader = endpoint;
    }

    public long commitIndex() {
        return this.commitIndex;
    }

    public void commitIndex(long index) {
        assert (index >= this.commitIndex) : "new commit index: " + index + " is smaller than current commit index: " + this.commitIndex;
        this.commitIndex = index;
    }

    public long lastApplied() {
        return this.lastApplied;
    }

    public void lastApplied(long index) {
        assert (index >= this.lastApplied) : "new last applied: " + index + " is smaller than current last applied: " + this.lastApplied;
        this.lastApplied = index;
    }

    public RaftLog log() {
        return this.log;
    }

    public LeaderState leaderState() {
        return this.leaderState;
    }

    public CandidateState candidateState() {
        return this.candidateState;
    }

    public void persistVote(int term, RaftEndpoint endpoint) {
        assert (this.term == term);
        assert (this.votedFor == null);
        this.votedFor = endpoint;
        this.persistTerm();
    }

    public void toFollower(int term) {
        this.role = RaftRole.FOLLOWER;
        this.leader = null;
        this.preCandidateState = null;
        this.leaderState = null;
        this.candidateState = null;
        this.completeLeadershipTransfer(null);
        this.setTerm(term);
        this.persistTerm();
    }

    public VoteRequest toCandidate(boolean disruptive) {
        this.role = RaftRole.CANDIDATE;
        this.preCandidateState = null;
        this.leaderState = null;
        this.candidateState = new CandidateState(this.majority());
        this.candidateState.grantVote(this.localEndpoint);
        this.setTerm(this.term + 1);
        this.persistVote(this.term, this.localEndpoint);
        return new VoteRequest(this.localEndpoint, this.term, this.log.lastLogOrSnapshotTerm(), this.log.lastLogOrSnapshotIndex(), disruptive);
    }

    private void setTerm(int newTerm) {
        assert (newTerm >= this.term) : "New term: " + newTerm + ", current term: " + this.term;
        this.term = newTerm;
        this.votedFor = null;
    }

    public void toLeader() {
        this.role = RaftRole.LEADER;
        this.leader(this.localEndpoint);
        this.preCandidateState = null;
        this.candidateState = null;
        this.leaderState = new LeaderState(this.lastGroupMembers.remoteMembers(), this.log.lastLogOrSnapshotIndex());
    }

    public boolean isKnownMember(RaftEndpoint endpoint) {
        return this.lastGroupMembers.isKnownMember(endpoint);
    }

    public void initPreCandidateState() {
        this.preCandidateState = new CandidateState(this.majority());
        this.preCandidateState.grantVote(this.localEndpoint);
    }

    public CandidateState preCandidateState() {
        return this.preCandidateState;
    }

    public void updateGroupMembers(long logIndex, Collection<RaftEndpoint> members) {
        assert (this.committedGroupMembers == this.lastGroupMembers) : "Cannot update group members to: " + members + " at log index: " + logIndex + " because last group members: " + this.lastGroupMembers + " is different than committed group members: " + this.committedGroupMembers;
        assert (this.lastGroupMembers.index() < logIndex) : "Cannot update group members to: " + members + " at log index: " + logIndex + " because last group members: " + this.lastGroupMembers + " has a bigger log index.";
        RaftGroupMembers newGroupMembers = new RaftGroupMembers(logIndex, members, this.localEndpoint);
        this.committedGroupMembers = this.lastGroupMembers;
        this.lastGroupMembers = newGroupMembers;
        if (this.leaderState != null) {
            for (RaftEndpoint endpoint : members) {
                if (this.committedGroupMembers.isKnownMember(endpoint)) continue;
                this.leaderState.add(endpoint, this.log.lastLogOrSnapshotIndex());
            }
            for (RaftEndpoint endpoint : this.committedGroupMembers.remoteMembers()) {
                if (members.contains(endpoint)) continue;
                this.leaderState.remove(endpoint);
            }
        }
    }

    public void commitGroupMembers() {
        assert (this.committedGroupMembers != this.lastGroupMembers) : "Cannot commit last group members: " + this.lastGroupMembers + " because it is same with committed group members";
        this.committedGroupMembers = this.lastGroupMembers;
    }

    public void resetGroupMembers() {
        assert (this.committedGroupMembers != this.lastGroupMembers);
        this.lastGroupMembers = this.committedGroupMembers;
    }

    public void restoreGroupMembers(long logIndex, Collection<RaftEndpoint> members) {
        RaftGroupMembers groupMembers;
        assert (this.lastGroupMembers.index() <= logIndex) : "Cannot restore group members to: " + members + " at log index: " + logIndex + " because last group members: " + this.lastGroupMembers + " has a bigger log index.";
        this.committedGroupMembers = groupMembers = new RaftGroupMembers(logIndex, members, this.localEndpoint);
        this.lastGroupMembers = groupMembers;
    }

    private void persistTerm() {
        try {
            this.store.persistTerm(this.term, this.votedFor);
        }
        catch (IOException e) {
            throw new HazelcastException(e);
        }
    }

    public boolean initLeadershipTransfer(RaftEndpoint targetEndpoint, InternalCompletableFuture resultFuture) {
        if (this.leadershipTransferState == null) {
            this.leadershipTransferState = new LeadershipTransferState(this.term, targetEndpoint, resultFuture);
            return true;
        }
        this.leadershipTransferState.notify(targetEndpoint, resultFuture);
        return false;
    }

    public void completeLeadershipTransfer(Object result) {
        if (this.leadershipTransferState == null) {
            return;
        }
        this.leadershipTransferState.complete(result);
        this.leadershipTransferState = null;
    }

    public LeadershipTransferState leadershipTransferState() {
        return this.leadershipTransferState;
    }
}

