/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.merge.MergingValue;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import java.io.IOException;
import org.hibernate.cache.spi.entry.CacheEntry;

public class VersionAwareMapMergePolicy
implements SplitBrainMergePolicy<Object, MergingValue<Object>> {
    @Override
    public Object merge(MergingValue<Object> mergingVal, MergingValue<Object> existingVal) {
        Object mergingValue;
        Object existingValue = existingVal != null ? existingVal.getValue() : null;
        Object object = mergingValue = mergingVal != null ? mergingVal.getValue() : null;
        if (existingValue instanceof CacheEntry && mergingValue instanceof CacheEntry) {
            CacheEntry existingCacheEntry = (CacheEntry)existingValue;
            CacheEntry mergingCacheEntry = (CacheEntry)mergingValue;
            Object mergingVersionObject = mergingCacheEntry.getVersion();
            Object existingVersionObject = existingCacheEntry.getVersion();
            if (mergingVersionObject instanceof Comparable && existingVersionObject instanceof Comparable) {
                Comparable mergingVersion = (Comparable)mergingVersionObject;
                Comparable existingVersion = (Comparable)existingVersionObject;
                if (mergingVersion.compareTo(existingVersion) > 0) {
                    return mergingValue;
                }
                return existingValue;
            }
        }
        return mergingValue;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
    }
}

