/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.ClientService;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.TerminatedLifecycleService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

public final class HazelcastInstanceProxy
implements HazelcastInstance,
SerializationServiceSupport {
    protected volatile HazelcastInstanceImpl original;
    private final String name;

    protected HazelcastInstanceProxy(HazelcastInstanceImpl original) {
        this.original = original;
        this.name = original.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return this.getOriginal().getMap(name);
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return this.getOriginal().getQueue(name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return this.getOriginal().getTopic(name);
    }

    @Override
    public <E> ITopic<E> getReliableTopic(String name) {
        return this.getOriginal().getReliableTopic(name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return this.getOriginal().getSet(name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return this.getOriginal().getList(name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return this.getOriginal().getMultiMap(name);
    }

    @Override
    public <E> Ringbuffer<E> getRingbuffer(String name) {
        return this.getOriginal().getRingbuffer(name);
    }

    @Override
    public IExecutorService getExecutorService(String name) {
        return this.getOriginal().getExecutorService(name);
    }

    @Override
    public DurableExecutorService getDurableExecutorService(String name) {
        return this.getOriginal().getDurableExecutorService(name);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.getOriginal().executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.getOriginal().executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.getOriginal().newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.getOriginal().newTransactionContext(options);
    }

    @Override
    public FlakeIdGenerator getFlakeIdGenerator(String name) {
        return this.getOriginal().getFlakeIdGenerator(name);
    }

    @Override
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return this.getOriginal().getReplicatedMap(name);
    }

    @Override
    public ICacheManager getCacheManager() {
        return this.getOriginal().getCacheManager();
    }

    @Override
    public Cluster getCluster() {
        return this.getOriginal().getCluster();
    }

    @Override
    public Member getLocalEndpoint() {
        return this.getOriginal().getLocalEndpoint();
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        return this.getOriginal().getDistributedObjects();
    }

    @Override
    public Config getConfig() {
        return this.getOriginal().getConfig();
    }

    @Override
    public PartitionService getPartitionService() {
        return this.getOriginal().getPartitionService();
    }

    @Override
    public SplitBrainProtectionService getSplitBrainProtectionService() {
        return this.getOriginal().getSplitBrainProtectionService();
    }

    @Override
    public ClientService getClientService() {
        return this.getOriginal().getClientService();
    }

    @Override
    public LoggingService getLoggingService() {
        return this.getOriginal().getLoggingService();
    }

    @Override
    public LifecycleService getLifecycleService() {
        HazelcastInstanceImpl hz = this.original;
        return hz != null ? hz.getLifecycleService() : new TerminatedLifecycleService();
    }

    @Override
    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return this.getOriginal().getDistributedObject(serviceName, name);
    }

    @Override
    public UUID addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.getOriginal().addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(UUID registrationId) {
        return this.getOriginal().removeDistributedObjectListener(registrationId);
    }

    @Override
    public ConcurrentMap<String, Object> getUserContext() {
        return this.getOriginal().getUserContext();
    }

    @Override
    public HazelcastXAResource getXAResource() {
        return this.getOriginal().getXAResource();
    }

    @Override
    public CardinalityEstimator getCardinalityEstimator(String name) {
        return this.getOriginal().getCardinalityEstimator(name);
    }

    @Override
    public PNCounter getPNCounter(String name) {
        return this.getOriginal().getPNCounter(name);
    }

    @Override
    public IScheduledExecutorService getScheduledExecutorService(String name) {
        return this.getOriginal().getScheduledExecutorService(name);
    }

    @Override
    public CPSubsystem getCPSubsystem() {
        return this.getOriginal().getCPSubsystem();
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.getOriginal().getSerializationService();
    }

    public HazelcastInstanceImpl getOriginal() {
        HazelcastInstanceImpl hazelcastInstance = this.original;
        if (hazelcastInstance == null) {
            throw new HazelcastInstanceNotActiveException();
        }
        return hazelcastInstance;
    }

    public String toString() {
        HazelcastInstanceImpl hazelcastInstance = this.original;
        if (hazelcastInstance != null) {
            return hazelcastInstance.toString();
        }
        return "HazelcastInstance {NOT ACTIVE}";
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof HazelcastInstance)) {
            return false;
        }
        HazelcastInstance that = (HazelcastInstance)o;
        return !(this.name == null ? that.getName() != null : !this.name.equals(that.getName()));
    }
}

