/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LifecycleServiceImpl
implements LifecycleService {
    private final HazelcastInstanceImpl instance;
    private final ConcurrentMap<UUID, LifecycleListener> lifecycleListeners = new ConcurrentHashMap<UUID, LifecycleListener>();
    private final Object lifecycleLock = new Object();

    public LifecycleServiceImpl(HazelcastInstanceImpl instance) {
        this.instance = instance;
    }

    private ILogger getLogger() {
        return this.instance.node.getLogger(LifecycleService.class.getName());
    }

    @Override
    public UUID addLifecycleListener(LifecycleListener lifecycleListener) {
        UUID id = UuidUtil.newUnsecureUUID();
        this.lifecycleListeners.put(id, lifecycleListener);
        return id;
    }

    @Override
    public boolean removeLifecycleListener(UUID registrationId) {
        return this.lifecycleListeners.remove(registrationId) != null;
    }

    public void fireLifecycleEvent(LifecycleEvent.LifecycleState lifecycleState) {
        this.fireLifecycleEvent(new LifecycleEvent(lifecycleState));
    }

    public void fireLifecycleEvent(LifecycleEvent lifecycleEvent) {
        this.getLogger().info(this.instance.node.getThisAddress() + " is " + (Object)((Object)lifecycleEvent.getState()));
        for (LifecycleListener lifecycleListener : this.lifecycleListeners.values()) {
            lifecycleListener.stateChanged(lifecycleEvent);
        }
    }

    @Override
    public boolean isRunning() {
        return this.instance.node.isRunning();
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public void terminate() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean terminate) {
        Object object = this.lifecycleLock;
        synchronized (object) {
            Node node;
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
            ManagementService managementService = this.instance.managementService;
            if (managementService != null) {
                managementService.destroy();
            }
            if ((node = this.instance.node) != null) {
                node.shutdown(terminate);
            }
            HazelcastInstanceFactory.remove(this.instance);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUnderLifecycleLock(Runnable runnable) {
        Object object = this.lifecycleLock;
        synchronized (object) {
            runnable.run();
        }
    }
}

