/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MetadataPolicy;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.management.JsonSerializable;
import com.hazelcast.internal.management.ManagementDataSerializerHook;
import com.hazelcast.internal.management.dto.MapStoreConfigDTO;
import com.hazelcast.internal.management.dto.MergePolicyConfigDTO;
import com.hazelcast.internal.management.dto.NearCacheConfigDTO;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class MapConfigDTO
implements JsonSerializable,
IdentifiedDataSerializable {
    private MapConfig mapConfig;

    public MapConfigDTO() {
    }

    public MapConfigDTO(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    @Override
    public JsonObject toJson() {
        String splitBrainProtectionName;
        JsonObject root = new JsonObject();
        String name = this.mapConfig.getName();
        if (!StringUtil.isNullOrEmpty(name)) {
            root.add("name", name);
        }
        if (!StringUtil.isNullOrEmpty(splitBrainProtectionName = this.mapConfig.getSplitBrainProtectionName())) {
            root.add("splitBrainProtectionName", splitBrainProtectionName);
        }
        root.add("maxSize", this.mapConfig.getMaxSizeConfig().getSize());
        root.add("maxSizePolicy", this.mapConfig.getMaxSizeConfig().getMaxSizePolicy().toString());
        root.add("evictionPolicy", this.mapConfig.getEvictionPolicy().name());
        root.add("memoryFormat", this.mapConfig.getInMemoryFormat().toString());
        root.add("cacheDeserializedValues", this.mapConfig.getCacheDeserializedValues().toString());
        root.add("metadataPolicy", this.mapConfig.getMetadataPolicy().toString());
        root.add("backupCount", this.mapConfig.getBackupCount());
        root.add("asyncBackupCount", this.mapConfig.getAsyncBackupCount());
        root.add("ttl", this.mapConfig.getTimeToLiveSeconds());
        root.add("maxIdle", this.mapConfig.getMaxIdleSeconds());
        root.add("readBackupData", this.mapConfig.isReadBackupData());
        root.add("statisticsEnabled", this.mapConfig.isStatisticsEnabled());
        root.add("mergePolicy", new MergePolicyConfigDTO(this.mapConfig.getMergePolicyConfig()).toJson());
        root.add("mapStoreConfig", new MapStoreConfigDTO(this.mapConfig.getMapStoreConfig()).toJson());
        NearCacheConfig nearCacheConfig = this.mapConfig.getNearCacheConfig();
        if (nearCacheConfig != null) {
            root.add("nearCacheConfig", new NearCacheConfigDTO(nearCacheConfig).toJson());
        }
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonValue splitBrainProtectionName;
        this.mapConfig = new MapConfig();
        JsonValue name = json.get("name");
        if (name != null && !name.isNull()) {
            this.mapConfig.setName(JsonUtil.getString(json, "name"));
        }
        if ((splitBrainProtectionName = json.get("splitBrainProtectionName")) != null && !splitBrainProtectionName.isNull()) {
            this.mapConfig.setSplitBrainProtectionName(JsonUtil.getString(json, "splitBrainProtectionName"));
        }
        this.mapConfig.setMaxSizeConfig(new MaxSizeConfig().setSize(JsonUtil.getInt(json, "maxSize")).setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.valueOf(JsonUtil.getString(json, "maxSizePolicy"))));
        this.mapConfig.setEvictionPolicy(EvictionPolicy.valueOf(JsonUtil.getString(json, "evictionPolicy")));
        this.mapConfig.setInMemoryFormat(InMemoryFormat.valueOf(JsonUtil.getString(json, "memoryFormat")));
        this.mapConfig.setCacheDeserializedValues(CacheDeserializedValues.valueOf(JsonUtil.getString(json, "cacheDeserializedValues")));
        this.mapConfig.setMetadataPolicy(MetadataPolicy.valueOf(JsonUtil.getString(json, "metadataPolicy")));
        this.mapConfig.setBackupCount(JsonUtil.getInt(json, "backupCount"));
        this.mapConfig.setAsyncBackupCount(JsonUtil.getInt(json, "asyncBackupCount"));
        this.mapConfig.setTimeToLiveSeconds(JsonUtil.getInt(json, "ttl"));
        this.mapConfig.setMaxIdleSeconds(JsonUtil.getInt(json, "maxIdle"));
        this.mapConfig.setReadBackupData(JsonUtil.getBoolean(json, "readBackupData"));
        this.mapConfig.setStatisticsEnabled(JsonUtil.getBoolean(json, "statisticsEnabled"));
        MergePolicyConfigDTO mergePolicyConfigDTO = new MergePolicyConfigDTO();
        mergePolicyConfigDTO.fromJson(JsonUtil.getObject(json, "mergePolicy"));
        this.mapConfig.setMergePolicyConfig(mergePolicyConfigDTO.getConfig());
        MapStoreConfigDTO mapStoreConfigDTO = new MapStoreConfigDTO();
        mapStoreConfigDTO.fromJson(JsonUtil.getObject(json, "mapStoreConfig"));
        this.mapConfig.setMapStoreConfig(mapStoreConfigDTO.getConfig());
        JsonValue nearCacheConfig = json.get("nearCacheConfig");
        if (nearCacheConfig != null && !nearCacheConfig.isNull()) {
            NearCacheConfigDTO nearCacheConfigDTO = new NearCacheConfigDTO();
            nearCacheConfigDTO.fromJson(nearCacheConfig.asObject());
            this.mapConfig.setNearCacheConfig(nearCacheConfigDTO.getConfig());
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapConfig.getName());
        out.writeUTF(this.mapConfig.getSplitBrainProtectionName());
        out.writeInt(this.mapConfig.getMaxSizeConfig().getSize());
        out.writeUTF(this.mapConfig.getMaxSizeConfig().getMaxSizePolicy().toString());
        out.writeUTF(this.mapConfig.getEvictionPolicy().name());
        out.writeUTF(this.mapConfig.getInMemoryFormat().toString());
        out.writeUTF(this.mapConfig.getCacheDeserializedValues().toString());
        out.writeUTF(this.mapConfig.getMetadataPolicy().toString());
        out.writeInt(this.mapConfig.getBackupCount());
        out.writeInt(this.mapConfig.getAsyncBackupCount());
        out.writeInt(this.mapConfig.getTimeToLiveSeconds());
        out.writeInt(this.mapConfig.getMaxIdleSeconds());
        out.writeBoolean(this.mapConfig.isReadBackupData());
        out.writeBoolean(this.mapConfig.isStatisticsEnabled());
        out.writeObject(this.mapConfig.getMergePolicyConfig());
        out.writeObject(this.mapConfig.getMapStoreConfig());
        out.writeObject(this.mapConfig.getNearCacheConfig());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapConfig = new MapConfig();
        this.mapConfig.setName(in.readUTF());
        this.mapConfig.setSplitBrainProtectionName(in.readUTF());
        this.mapConfig.setMaxSizeConfig(new MaxSizeConfig().setSize(in.readInt()).setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.valueOf(in.readUTF())));
        this.mapConfig.setEvictionPolicy(EvictionPolicy.valueOf(in.readUTF()));
        this.mapConfig.setInMemoryFormat(InMemoryFormat.valueOf(in.readUTF()));
        this.mapConfig.setCacheDeserializedValues(CacheDeserializedValues.valueOf(in.readUTF()));
        this.mapConfig.setMetadataPolicy(MetadataPolicy.valueOf(in.readUTF()));
        this.mapConfig.setBackupCount(in.readInt());
        this.mapConfig.setAsyncBackupCount(in.readInt());
        this.mapConfig.setTimeToLiveSeconds(in.readInt());
        this.mapConfig.setMaxIdleSeconds(in.readInt());
        this.mapConfig.setReadBackupData(in.readBoolean());
        this.mapConfig.setStatisticsEnabled(in.readBoolean());
        this.mapConfig.setMergePolicyConfig((MergePolicyConfig)in.readObject());
        this.mapConfig.setMapStoreConfig((MapStoreConfig)in.readObject());
        this.mapConfig.setNearCacheConfig((NearCacheConfig)in.readObject());
    }

    public MapConfig getConfig() {
        return this.mapConfig;
    }

    @Override
    public int getFactoryId() {
        return ManagementDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }
}

