/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.management.JsonSerializable;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.internal.util.StringUtil;
import java.util.Map;
import java.util.Properties;

class MapStoreConfigDTO
implements JsonSerializable {
    private MapStoreConfig mapStoreConfig;

    MapStoreConfigDTO() {
    }

    MapStoreConfigDTO(MapStoreConfig mapStoreConfig) {
        this.mapStoreConfig = mapStoreConfig;
    }

    @Override
    public JsonObject toJson() {
        String factoryClassName;
        JsonObject root = new JsonObject().add("enabled", this.mapStoreConfig.isEnabled()).add("writeBatchSize", this.mapStoreConfig.getWriteBatchSize()).add("writeDelaySeconds", this.mapStoreConfig.getWriteDelaySeconds()).add("writeCoalescing", this.mapStoreConfig.isWriteCoalescing()).add("initialLoadMode", this.mapStoreConfig.getInitialLoadMode().toString()).add("properties", MapStoreConfigDTO.toJsonObject(this.mapStoreConfig.getProperties()));
        String className = this.mapStoreConfig.getClassName();
        if (!StringUtil.isNullOrEmpty(className)) {
            root.add("className", className);
        }
        if (!StringUtil.isNullOrEmpty(factoryClassName = this.mapStoreConfig.getFactoryClassName())) {
            root.add("factoryClassName", factoryClassName);
        }
        return root;
    }

    private static JsonObject toJsonObject(Properties properties) {
        JsonObject object = new JsonObject();
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            object.add(property.getKey().toString(), Json.value(property.getValue().toString()));
        }
        return object;
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonValue factoryClassName;
        this.mapStoreConfig = new MapStoreConfig();
        this.mapStoreConfig.setEnabled(JsonUtil.getBoolean(json, "enabled"));
        this.mapStoreConfig.setWriteBatchSize(JsonUtil.getInt(json, "writeBatchSize"));
        this.mapStoreConfig.setWriteDelaySeconds(JsonUtil.getInt(json, "writeDelaySeconds"));
        this.mapStoreConfig.setWriteCoalescing(JsonUtil.getBoolean(json, "writeCoalescing"));
        this.mapStoreConfig.setInitialLoadMode(MapStoreConfig.InitialLoadMode.valueOf(JsonUtil.getString(json, "initialLoadMode")));
        this.mapStoreConfig.setProperties(MapStoreConfigDTO.fromJsonObject(json));
        JsonValue className = json.get("className");
        if (className != null && !className.isNull()) {
            this.mapStoreConfig.setClassName(JsonUtil.getString(json, "className"));
        }
        if ((factoryClassName = json.get("factoryClassName")) != null && !factoryClassName.isNull()) {
            this.mapStoreConfig.setFactoryClassName(JsonUtil.getString(json, "factoryClassName"));
        }
    }

    private static Properties fromJsonObject(JsonObject json) {
        Properties properties = new Properties();
        JsonObject jsonObject = JsonUtil.getObject(json, "properties");
        for (JsonObject.Member property : jsonObject) {
            properties.put(property.getName(), property.getValue().asString());
        }
        return properties;
    }

    public MapStoreConfig getConfig() {
        return this.mapStoreConfig;
    }
}

