/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.JsonSerializable;
import com.hazelcast.internal.management.dto.EvictionConfigDTO;
import com.hazelcast.internal.management.dto.NearCachePreloaderConfigDTO;
import com.hazelcast.internal.util.JsonUtil;

class NearCacheConfigDTO
implements JsonSerializable {
    private NearCacheConfig nearCacheConfig;

    NearCacheConfigDTO() {
    }

    NearCacheConfigDTO(NearCacheConfig nearCacheConfig) {
        this.nearCacheConfig = nearCacheConfig;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject().add("name", this.nearCacheConfig.getName()).add("cacheLocalEntries", this.nearCacheConfig.isCacheLocalEntries()).add("serializeKeys", this.nearCacheConfig.isSerializeKeys()).add("invalidateOnChange", this.nearCacheConfig.isInvalidateOnChange()).add("timeToLiveSeconds", this.nearCacheConfig.getTimeToLiveSeconds()).add("maxIdleSeconds", this.nearCacheConfig.getMaxIdleSeconds()).add("inMemoryFormat", this.nearCacheConfig.getInMemoryFormat().toString()).add("localUpdatePolicy", this.nearCacheConfig.getLocalUpdatePolicy().toString());
        EvictionConfigDTO evictionConfigDTO = new EvictionConfigDTO(this.nearCacheConfig.getEvictionConfig());
        root.add("evictionConfig", evictionConfigDTO.toJson());
        NearCachePreloaderConfigDTO preloaderConfigDTO = new NearCachePreloaderConfigDTO(this.nearCacheConfig.getPreloaderConfig());
        root.add("preloaderConfig", preloaderConfigDTO.toJson());
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.nearCacheConfig = new NearCacheConfig();
        this.nearCacheConfig.setName(JsonUtil.getString(json, "name"));
        this.nearCacheConfig.setCacheLocalEntries(JsonUtil.getBoolean(json, "cacheLocalEntries"));
        this.nearCacheConfig.setSerializeKeys(JsonUtil.getBoolean(json, "serializeKeys"));
        this.nearCacheConfig.setInvalidateOnChange(JsonUtil.getBoolean(json, "invalidateOnChange"));
        this.nearCacheConfig.setTimeToLiveSeconds(JsonUtil.getInt(json, "timeToLiveSeconds"));
        this.nearCacheConfig.setMaxIdleSeconds(JsonUtil.getInt(json, "maxIdleSeconds"));
        this.nearCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(JsonUtil.getString(json, "inMemoryFormat")));
        this.nearCacheConfig.setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.valueOf(JsonUtil.getString(json, "localUpdatePolicy")));
        EvictionConfigDTO evictionConfigDTO = new EvictionConfigDTO();
        evictionConfigDTO.fromJson(JsonUtil.getObject(json, "evictionConfig"));
        this.nearCacheConfig.setEvictionConfig(evictionConfigDTO.getConfig());
        NearCachePreloaderConfigDTO preloaderConfigDTO = new NearCachePreloaderConfigDTO();
        preloaderConfigDTO.fromJson(JsonUtil.getObject(json, "preloaderConfig"));
        this.nearCacheConfig.setPreloaderConfig(preloaderConfigDTO.getConfig());
    }

    public NearCacheConfig getConfig() {
        return this.nearCacheConfig;
    }
}

