/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.MetricTagger;
import com.hazelcast.internal.metrics.MetricsUtil;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.metrics.impl.FieldProbe;
import com.hazelcast.internal.metrics.impl.MethodProbe;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class MetricTaggerImpl
implements MetricTagger {
    private final MetricsRegistryImpl metricsRegistry;
    private final String keyPrefix;
    private final String metricNamePrefix;
    private final String id;
    private final String metricName;

    MetricTaggerImpl(MetricsRegistryImpl metricsRegistry, String metricNamePrefix) {
        this.metricsRegistry = metricsRegistry;
        this.keyPrefix = "[";
        this.metricNamePrefix = metricNamePrefix;
        this.id = null;
        this.metricName = null;
    }

    private MetricTaggerImpl(MetricTaggerImpl tagger, String keyPrefix) {
        this(tagger, keyPrefix, tagger.id, tagger.metricName);
    }

    private MetricTaggerImpl(MetricTaggerImpl tagger, String keyPrefix, String id, String metricName) {
        this.metricsRegistry = tagger.metricsRegistry;
        this.keyPrefix = keyPrefix;
        this.metricNamePrefix = tagger.metricNamePrefix;
        this.id = id;
        this.metricName = metricName;
    }

    @Override
    @CheckReturnValue
    public MetricTaggerImpl withTag(String tag, String value) {
        assert (MetricsUtil.containsSpecialCharacters(tag)) : "tag contains special characters";
        return new MetricTaggerImpl(this, this.getKeyPrefix(tag, value));
    }

    private String getKeyPrefix(String tag, String value) {
        return this.keyPrefix + (this.keyPrefix.length() == 1 ? "" : ",") + tag + '=' + MetricsUtil.escapeMetricNamePart(value);
    }

    @Override
    @CheckReturnValue
    public MetricTaggerImpl withIdTag(String tag, String value) {
        assert (MetricsUtil.containsSpecialCharacters(tag)) : "tag contains special characters";
        return new MetricTaggerImpl(this, this.getKeyPrefix(tag, value), value, this.metricName);
    }

    @Override
    public MetricTaggerImpl withMetricTag(String metricName) {
        String prefixedMetricName = this.metricNamePrefix != null ? this.metricNamePrefix + '.' + metricName : metricName;
        return new MetricTaggerImpl(this, this.getKeyPrefix("metric", prefixedMetricName), this.id, metricName);
    }

    @Override
    public String metricName() {
        String metricName = this.keyPrefix + ']';
        assert (metricName != null && !metricName.equals("[]"));
        return metricName;
    }

    @Override
    public String metricId() {
        StringBuilder sb = new StringBuilder();
        if (this.metricNamePrefix != null) {
            sb.append(this.metricNamePrefix);
        }
        if (this.id != null) {
            sb.append('[').append(this.id).append(']');
        }
        if (this.metricName != null) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(this.metricName);
        }
        return sb.toString();
    }

    @Override
    public <S> void registerStaticProbe(@Nonnull S source, @Nonnull String metricName, @Nonnull ProbeLevel level, @Nonnull ProbeUnit unit, @Nonnull DoubleProbeFunction<S> probe) {
        MetricTaggerImpl tagger = this.withTag("unit", unit.name().toLowerCase()).withMetricTag(metricName);
        this.metricsRegistry.registerInternal(source, tagger, level, probe);
    }

    @Override
    public <S> void registerStaticProbe(@Nonnull S source, @Nonnull String metricName, @Nonnull ProbeLevel level, @Nonnull DoubleProbeFunction<S> probe) {
        MetricTaggerImpl tagger = this.withMetricTag(metricName);
        this.metricsRegistry.registerInternal(source, tagger, level, probe);
    }

    @Override
    public <S> void registerStaticProbe(@Nonnull S source, @Nonnull String metricName, @Nonnull ProbeLevel level, @Nonnull ProbeUnit unit, @Nonnull LongProbeFunction<S> probe) {
        MetricTaggerImpl tagger = this.withTag("unit", unit.name().toLowerCase()).withMetricTag(metricName);
        this.metricsRegistry.registerInternal(source, tagger, level, probe);
    }

    @Override
    public <S> void registerStaticProbe(@Nonnull S source, @Nonnull String metricName, @Nonnull ProbeLevel level, @Nonnull LongProbeFunction<S> probe) {
        MetricTaggerImpl tagger = this.withMetricTag(metricName);
        this.metricsRegistry.registerInternal(source, tagger, level, probe);
    }

    <S> void registerStaticProbe(S source, String metricName, ProbeLevel level, ProbeFunction probe) {
        this.metricsRegistry.registerInternal(source, this.withMetricTag(metricName), level, probe);
    }

    @Override
    public <S> void registerStaticMetrics(S source) {
        SourceMetadata metadata = this.metricsRegistry.loadSourceMetadata(source.getClass());
        for (FieldProbe field : metadata.fields()) {
            field.register(this, source);
        }
        for (MethodProbe method : metadata.methods()) {
            method.register(this, source);
        }
    }
}

