/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.MetricTagger;
import com.hazelcast.internal.metrics.MetricTaggerSupplier;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeAware;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.FieldProbe;
import com.hazelcast.internal.metrics.impl.MethodProbe;
import com.hazelcast.internal.metrics.impl.ProbeInstance;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;

class MetricsCollectionCycle {
    private final MetricTaggerSupplier taggerSupplier;
    private final Function<Class, SourceMetadata> lookupMetadataFunction;
    private final MetricsCollector metricsCollector;
    private final ProbeLevel minimumLevel;

    MetricsCollectionCycle(MetricTaggerSupplier taggerSupplier, Function<Class, SourceMetadata> lookupMetadataFunction, MetricsCollector metricsCollector, ProbeLevel minimumLevel) {
        this.taggerSupplier = taggerSupplier;
        this.lookupMetadataFunction = lookupMetadataFunction;
        this.metricsCollector = metricsCollector;
        this.minimumLevel = minimumLevel;
    }

    void collectStaticMetrics(Collection<ProbeInstance> probeInstances) {
        for (ProbeInstance probeInstance : probeInstances) {
            ProbeFunction function = probeInstance.function;
            if (function instanceof LongProbeFunction) {
                this.collectLong(probeInstance.source, probeInstance.name, (LongProbeFunction)function);
                continue;
            }
            if (function instanceof DoubleProbeFunction) {
                this.collectDouble(probeInstance.source, probeInstance.name, (DoubleProbeFunction)function);
                continue;
            }
            throw new IllegalStateException("Unhandled ProbeFunction encountered: " + function.getClass().getName());
        }
    }

    void collectDynamicMetrics(Collection<DynamicMetricsProvider> metricsSources) {
        for (DynamicMetricsProvider metricsSource : metricsSources) {
            metricsSource.provideDynamicMetrics(this.taggerSupplier, this::extractAndCollectDynamicMetrics);
        }
    }

    private void extractAndCollectDynamicMetrics(MetricTagger tagger, Object source) {
        String name;
        SourceMetadata metadata = this.lookupMetadataFunction.apply(source.getClass());
        for (MethodProbe methodProbe : metadata.methods()) {
            if (!methodProbe.probe.level().isEnabled(this.minimumLevel)) continue;
            name = tagger.withTag("unit", methodProbe.probe.unit().name().toLowerCase()).withMetricTag(methodProbe.getProbeOrMethodName()).metricName();
            this.collect(name, source, methodProbe);
        }
        for (FieldProbe fieldProbe : metadata.fields()) {
            if (!fieldProbe.probe.level().isEnabled(this.minimumLevel)) continue;
            name = tagger.withTag("unit", fieldProbe.probe.unit().name().toLowerCase()).withMetricTag(fieldProbe.getProbeOrFieldName()).metricName();
            this.collect(name, source, fieldProbe);
        }
    }

    private void collect(String name, Object source, ProbeFunction function) {
        Set<MetricTarget> excludedTargets = this.getExcludedTargets(function);
        if (function == null || source == null) {
            this.metricsCollector.collectNoValue(name, excludedTargets);
            return;
        }
        if (function instanceof LongProbeFunction) {
            LongProbeFunction longFunction = (LongProbeFunction)function;
            this.collectLong(source, name, longFunction);
        } else {
            DoubleProbeFunction doubleFunction = (DoubleProbeFunction)function;
            this.collectDouble(source, name, doubleFunction);
        }
    }

    private void collectDouble(Object source, String name, DoubleProbeFunction function) {
        Set<MetricTarget> excludedTargets = this.getExcludedTargets(function);
        try {
            double value = function.get(source);
            this.metricsCollector.collectDouble(name, value, excludedTargets);
        }
        catch (Exception ex) {
            this.metricsCollector.collectException(name, ex, excludedTargets);
        }
    }

    private void collectLong(Object source, String name, LongProbeFunction function) {
        Set<MetricTarget> excludedTargets = this.getExcludedTargets(function);
        try {
            long value = function.get(source);
            this.metricsCollector.collectLong(name, value, excludedTargets);
        }
        catch (Exception ex) {
            this.metricsCollector.collectException(name, ex, excludedTargets);
        }
    }

    private Set<MetricTarget> getExcludedTargets(Object object) {
        if (object instanceof ProbeAware) {
            Probe probe = ((ProbeAware)object).getProbe();
            return this.getExcludedTargets(probe);
        }
        return Collections.emptySet();
    }

    private Set<MetricTarget> getExcludedTargets(Probe probe) {
        MetricTarget[] excludedTargets = probe.excludedTargets();
        if (excludedTargets.length > 0) {
            EnumSet<MetricTarget> metricTargets = EnumSet.noneOf(MetricTarget.class);
            Collections.addAll(metricTargets, excludedTargets);
            return metricTargets;
        }
        return Collections.emptySet();
    }
}

