/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleGauge;
import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.MetricTagger;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.StaticMetricsProvider;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.DoubleGaugeImpl;
import com.hazelcast.internal.metrics.impl.LongGaugeImpl;
import com.hazelcast.internal.metrics.impl.MetricTaggerImpl;
import com.hazelcast.internal.metrics.impl.MetricsCollectionCycle;
import com.hazelcast.internal.metrics.impl.ProbeInstance;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import com.hazelcast.internal.util.ConcurrentReferenceHashMap;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.concurrent.ThreadFactoryImpl;
import com.hazelcast.logging.ILogger;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MetricsRegistryImpl
implements MetricsRegistry {
    final ILogger logger;
    private final ProbeLevel minimumLevel;
    private final ScheduledExecutorService scheduler;
    private final ConcurrentMap<String, ProbeInstance> probeInstances = new ConcurrentHashMap<String, ProbeInstance>();
    private final ConcurrentMap<Class<?>, SourceMetadata> metadataMap = new ConcurrentReferenceHashMap();
    private final ConcurrentMap<DynamicMetricsProvider, Boolean> metricSourceMap = new ConcurrentReferenceHashMap<DynamicMetricsProvider, Boolean>(ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.STRONG, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));

    public MetricsRegistryImpl(ILogger logger, ProbeLevel minimumLevel) {
        this("default", logger, minimumLevel);
    }

    public MetricsRegistryImpl(String name, ILogger logger, ProbeLevel minimumLevel) {
        this.logger = Preconditions.checkNotNull(logger, "logger can't be null");
        this.minimumLevel = Preconditions.checkNotNull(minimumLevel, "minimumLevel can't be null");
        this.scheduler = new ScheduledThreadPoolExecutor(2, new ThreadFactoryImpl(ThreadUtil.createThreadPoolName(name, "MetricsRegistry")));
        if (logger.isFinestEnabled()) {
            logger.finest("MetricsRegistry minimumLevel:" + (Object)((Object)minimumLevel));
        }
    }

    @Override
    public ProbeLevel minimumLevel() {
        return this.minimumLevel;
    }

    @Override
    public Set<String> getNames() {
        return Collections.unmodifiableSet(this.probeInstances.values().stream().map(probeInstance -> probeInstance.name).collect(Collectors.toSet()));
    }

    SourceMetadata loadSourceMetadata(Class<?> clazz) {
        SourceMetadata metadata = (SourceMetadata)this.metadataMap.get(clazz);
        if (metadata == null) {
            metadata = new SourceMetadata(clazz);
            SourceMetadata found = this.metadataMap.putIfAbsent(clazz, metadata);
            metadata = found == null ? metadata : found;
        }
        return metadata;
    }

    @Override
    public <S> void registerStaticMetrics(S source, String namePrefix) {
        Preconditions.checkNotNull(source, "source can't be null");
        Preconditions.checkNotNull(namePrefix, "namePrefix can't be null");
        this.newMetricTagger(namePrefix).registerStaticMetrics(source);
    }

    @Override
    public void registerDynamicMetricsProvider(DynamicMetricsProvider metricsProvider) {
        this.metricSourceMap.put(metricsProvider, Boolean.TRUE);
    }

    @Override
    public void deregisterDynamicMetricsProvider(DynamicMetricsProvider metricsProvider) {
        this.metricSourceMap.remove(metricsProvider);
    }

    @Override
    public <S> void registerStaticProbe(S source, String name, ProbeLevel level, LongProbeFunction<S> function) {
        Preconditions.checkNotNull(source, "source can't be null");
        Preconditions.checkNotNull(name, "name can't be null");
        Preconditions.checkNotNull(function, "function can't be null");
        Preconditions.checkNotNull(level, "level can't be null");
        this.registerInternal(source, this.newMetricTagger().withMetricTag(name), level, function);
    }

    @Override
    public <S> void registerStaticProbe(S source, String name, ProbeLevel level, DoubleProbeFunction<S> function) {
        Preconditions.checkNotNull(source, "source can't be null");
        Preconditions.checkNotNull(name, "name can't be null");
        Preconditions.checkNotNull(function, "function can't be null");
        Preconditions.checkNotNull(level, "level can't be null");
        MetricTagger metricTagger = this.newMetricTagger();
        this.registerInternal(source, metricTagger.withMetricTag(name), level, function);
    }

    ProbeInstance getProbeInstance(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        return (ProbeInstance)this.probeInstances.get(name);
    }

    <S> void registerInternal(S source, MetricTagger tagger, ProbeLevel probeLevel, ProbeFunction function) {
        if (!probeLevel.isEnabled(this.minimumLevel)) {
            return;
        }
        String metricId = tagger.metricId();
        String metricName = tagger.metricName();
        ProbeInstance probeInstance = this.probeInstances.computeIfAbsent(metricId, k -> new ProbeInstance<Object>(metricName, source, function));
        if (probeInstance.source == source && probeInstance.function == function) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Registered probeInstance " + metricName);
            }
        } else {
            this.logOverwrite(probeInstance);
            probeInstance.source = source;
            probeInstance.function = function;
        }
    }

    private void logOverwrite(ProbeInstance probeInstance) {
        if (probeInstance.function != null || probeInstance.source != null) {
            this.logger.warning(String.format("Overwriting existing probe '%s'", probeInstance.name));
        }
    }

    @Override
    public LongGaugeImpl newLongGauge(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        return new LongGaugeImpl(this, name);
    }

    @Override
    public DoubleGauge newDoubleGauge(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        return new DoubleGaugeImpl(this, name);
    }

    @Override
    public void collect(MetricsCollector collector) {
        Preconditions.checkNotNull(collector, "collector can't be null");
        MetricsCollectionCycle collectionCycle = new MetricsCollectionCycle(this::newMetricTagger, this::loadSourceMetadata, collector, this.minimumLevel);
        collectionCycle.collectStaticMetrics(this.probeInstances.values());
        collectionCycle.collectDynamicMetrics(this.metricSourceMap.keySet());
    }

    @Override
    public void provideMetrics(Object ... providers) {
        for (Object provider : providers) {
            if (!(provider instanceof StaticMetricsProvider)) continue;
            ((StaticMetricsProvider)provider).provideStaticMetrics(this);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable publisher, long period, TimeUnit timeUnit, ProbeLevel probeLevel) {
        if (!probeLevel.isEnabled(this.minimumLevel)) {
            return null;
        }
        return this.scheduler.scheduleAtFixedRate(publisher, 0L, period, timeUnit);
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
    }

    @Override
    public MetricTagger newMetricTagger() {
        return new MetricTaggerImpl(this, null);
    }

    @Override
    public MetricTagger newMetricTagger(String namePrefix) {
        return new MetricTaggerImpl(this, namePrefix);
    }
}

