/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.config.MetricsConfig;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.MetricsPublisher;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.LiveOperationRegistry;
import com.hazelcast.internal.metrics.jmx.JmxPublisher;
import com.hazelcast.internal.metrics.managementcenter.ConcurrentArrayRingbuffer;
import com.hazelcast.internal.metrics.managementcenter.ManagementCenterPublisher;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.LiveOperations;
import com.hazelcast.spi.impl.operationservice.LiveOperationsTracker;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MetricsService
implements ManagedService,
LiveOperationsTracker {
    public static final String SERVICE_NAME = "hz:impl:metricsService";
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final MetricsConfig config;
    private final LiveOperationRegistry liveOperationRegistry;
    private final ConcurrentMap<CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>, Long> pendingReads = new ConcurrentHashMap<CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>, Long>();
    private final MetricsCollector metricsCollector = new PublisherMetricsCollector();
    private volatile boolean collectorScheduled;
    private ConcurrentArrayRingbuffer<Map.Entry<Long, byte[]>> metricsJournal;
    private volatile ScheduledFuture<?> scheduledFuture;
    private final List<MetricsPublisher> publishers;
    private final Supplier<MetricsRegistry> metricsRegistrySupplier;

    public MetricsService(NodeEngine nodeEngine) {
        this(nodeEngine, ((NodeEngineImpl)nodeEngine)::getMetricsRegistry);
    }

    public MetricsService(NodeEngine nodeEngine, Supplier<MetricsRegistry> metricsRegistrySupplier) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.config = nodeEngine.getConfig().getMetricsConfig();
        this.liveOperationRegistry = new LiveOperationRegistry();
        this.metricsRegistrySupplier = metricsRegistrySupplier;
        this.publishers = new CopyOnWriteArrayList<MetricsPublisher>();
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        if (this.config.isEnabled()) {
            if (this.config.isMcEnabled()) {
                this.publishers.add(this.createMcPublisher());
            }
            if (this.config.isJmxEnabled()) {
                this.publishers.add(this.createJmxPublisher());
            }
            if (!this.publishers.isEmpty()) {
                this.scheduleMetricsCollectorIfNeeded();
            }
        } else {
            this.logger.fine("Metrics collection is disabled");
        }
    }

    public void registerPublisher(Function<NodeEngine, MetricsPublisher> registerFunction) {
        if (this.config.isEnabled()) {
            MetricsPublisher publisher = registerFunction.apply(this.nodeEngine);
            this.publishers.add(publisher);
            this.scheduleMetricsCollectorIfNeeded();
        } else {
            this.logger.fine(String.format("Custom publisher is not registered with function %s as the metrics system is disabled", registerFunction));
        }
    }

    private void scheduleMetricsCollectorIfNeeded() {
        if (!this.collectorScheduled && !this.publishers.isEmpty()) {
            this.logger.fine("Configuring metrics collection, collection interval=" + this.config.getCollectionIntervalSeconds() + " seconds, retention=" + this.config.getRetentionSeconds() + " seconds, publishers=" + this.publishers.stream().map(MetricsPublisher::name).collect(Collectors.joining(", ", "[", "]")));
            ExecutionService executionService = this.nodeEngine.getExecutionService();
            this.scheduledFuture = executionService.scheduleWithRepetition("MetricsPublisher", this::collectMetrics, 1L, this.config.getCollectionIntervalSeconds(), TimeUnit.SECONDS);
            this.collectorScheduled = true;
        }
    }

    void collectMetrics() {
        this.collectMetrics(this.metricsCollector);
    }

    void collectMetrics(MetricsCollector metricsCollector) {
        this.metricsRegistrySupplier.get().collect(metricsCollector);
        for (MetricsPublisher publisher : this.publishers) {
            try {
                publisher.whenComplete();
            }
            catch (Exception e) {
                this.logger.severe("Error completing publication for publisher " + publisher, e);
            }
        }
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    @Override
    public void populate(LiveOperations liveOperations) {
        this.liveOperationRegistry.populate(liveOperations);
    }

    public CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> readMetrics(long startSequence) {
        if (!this.config.isEnabled()) {
            throw new IllegalArgumentException("Metrics collection is not enabled");
        }
        CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> future = new CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>();
        future.whenComplete(ExceptionUtil.withTryCatch(this.logger, (s, e) -> {
            Long cfr_ignored_0 = (Long)this.pendingReads.remove(future);
        }));
        this.pendingReads.put(future, startSequence);
        this.tryCompleteRead(future, startSequence);
        return future;
    }

    private void tryCompleteRead(CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> future, long sequence) {
        try {
            ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>> slice = this.metricsJournal.copyFrom(sequence);
            if (!slice.isEmpty()) {
                future.complete(slice);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error reading from metrics journal, sequence: " + sequence, e);
            future.completeExceptionally(e);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        for (MetricsPublisher publisher : this.publishers) {
            try {
                publisher.shutdown();
            }
            catch (Exception e) {
                this.logger.warning("Error shutting down metrics publisher " + publisher.name(), e);
            }
        }
    }

    private JmxPublisher createJmxPublisher() {
        return new JmxPublisher(this.nodeEngine.getHazelcastInstance().getName(), "com.hazelcast");
    }

    private ManagementCenterPublisher createMcPublisher() {
        int journalSize = Math.max(1, (int)Math.ceil((double)this.config.getRetentionSeconds() / (double)this.config.getCollectionIntervalSeconds()));
        this.metricsJournal = new ConcurrentArrayRingbuffer(journalSize);
        return new ManagementCenterPublisher(this.nodeEngine.getLoggingService(), (blob, ts) -> {
            this.metricsJournal.add(MapUtil.entry(ts, blob));
            this.pendingReads.forEach(this::tryCompleteRead);
        });
    }

    private class PublisherMetricsCollector
    implements MetricsCollector {
        private PublisherMetricsCollector() {
        }

        @Override
        public void collectLong(String name, long value, Set<MetricTarget> excludedTargets) {
            for (MetricsPublisher publisher : MetricsService.this.publishers) {
                try {
                    publisher.publishLong(name, value, excludedTargets);
                }
                catch (Exception e) {
                    this.logError(name, value, publisher, e);
                }
            }
        }

        @Override
        public void collectDouble(String name, double value, Set<MetricTarget> excludedTargets) {
            for (MetricsPublisher publisher : MetricsService.this.publishers) {
                try {
                    publisher.publishDouble(name, value, excludedTargets);
                }
                catch (Exception e) {
                    this.logError(name, value, publisher, e);
                }
            }
        }

        @Override
        public void collectException(String name, Exception e, Set<MetricTarget> excludedTargets) {
            MetricsService.this.logger.warning("Error when rendering '" + name + '\'', e);
        }

        @Override
        public void collectNoValue(String name, Set<MetricTarget> excludedTargets) {
        }

        private void logError(String name, Object value, MetricsPublisher publisher, Exception e) {
            MetricsService.this.logger.fine("Error publishing metric to: " + publisher.name() + ", metric=" + name + ", value=" + value, e);
        }
    }
}

