/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.jmx;

import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.ExceptionUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;

public class MetricsMBean
implements DynamicMBean {
    private final ConcurrentMap<String, BiTuple<String, AtomicReference<Number>>> metrics = new ConcurrentHashMap<String, BiTuple<String, AtomicReference<Number>>>();

    void setMetricValue(String name, String unit, Number value) {
        ((AtomicReference)this.metrics.computeIfAbsent((String)name, (Function<String, BiTuple>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setMetricValue$0(java.lang.String java.lang.String ), (Ljava/lang/String;)Lcom/hazelcast/internal/util/BiTuple;)((String)unit)).element2).lazySet(value);
    }

    void removeMetric(String name) {
        this.metrics.remove(name);
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException {
        BiTuple attribute = (BiTuple)this.metrics.get(attributeName);
        if (attribute == null) {
            throw new AttributeNotFoundException(attributeName);
        }
        return ((AtomicReference)attribute.element2).get();
    }

    @Override
    public void setAttribute(Attribute attribute) {
        throw new UnsupportedOperationException("setting attributes is not supported");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return Arrays.stream(attributes).filter(this.metrics::containsKey).map(a -> MetricsMBean.uncheckCall(() -> new Attribute((String)a, this.getAttribute((String)a)))).collect(Collectors.toCollection(AttributeList::new));
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("setting attributes is not supported");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        throw new UnsupportedOperationException("invoking is not supported");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] array = new MBeanAttributeInfo[this.metrics.size()];
        int i = 0;
        for (Map.Entry entry : this.metrics.entrySet()) {
            array[i++] = new MBeanAttributeInfo((String)entry.getKey(), "", "Unit: " + (String)((BiTuple)entry.getValue()).element1, true, false, false);
        }
        return new MBeanInfo("Metric", "", array, null, null, null, null);
    }

    int numAttributes() {
        return this.metrics.size();
    }

    private static <T> T uncheckCall(@Nonnull Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    private static /* synthetic */ BiTuple lambda$setMetricValue$0(String unit, String k) {
        return BiTuple.of(unit, new AtomicReference());
    }
}

