/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.managementcenter;

import com.hazelcast.internal.metrics.managementcenter.MetricConsumer;
import com.hazelcast.internal.metrics.managementcenter.MetricsCompressor;

public final class Metric {
    private final String key;
    private final MetricsCompressor.ValueType type;
    private long longValue;
    private double doubleValue;

    Metric(String key, MetricsCompressor.ValueType type, long value) {
        this.key = key;
        this.type = type;
        this.longValue = value;
    }

    Metric(String key, MetricsCompressor.ValueType type, double value) {
        this.key = key;
        this.type = type;
        this.doubleValue = value;
    }

    public void provide(MetricConsumer consumer) {
        switch (this.type) {
            case LONG: {
                consumer.consumeLong(this.key, this.longValue);
                break;
            }
            case DOUBLE: {
                consumer.consumeDouble(this.key, this.doubleValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected metric value type: " + (Object)((Object)this.type));
            }
        }
    }
}

