/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.internal.metrics.MetricTagger;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.Preconditions;
import java.io.File;

public final class FileMetricSet {
    private FileMetricSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        File file = new File(System.getProperty("user.home"));
        MetricTagger tagger = metricsRegistry.newMetricTagger("file.partition").withIdTag("dir", "user.home");
        tagger.registerStaticProbe(file, "freeSpace", ProbeLevel.MANDATORY, ProbeUnit.BYTES, File::getFreeSpace);
        tagger.registerStaticProbe(file, "totalSpace", ProbeLevel.MANDATORY, ProbeUnit.BYTES, File::getTotalSpace);
        tagger.registerStaticProbe(file, "usableSpace", ProbeLevel.MANDATORY, ProbeUnit.BYTES, File::getUsableSpace);
    }
}

